/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpConfigurationOptionsComponent
extends TextFieldWithBrowseButton
implements UserActivityProviderComponent,
Disposable {
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private List<PhpConfigurationOptionData> myConfigurationOptions = new ArrayList<PhpConfigurationOptionData>();

    public PhpConfigurationOptionsComponent() {
        this.setEditable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyEditor editor = new MyEditor((JComponent)((Object)PhpConfigurationOptionsComponent.this), PhpConfigurationOptionsComponent.this.getConfigurationOptionsData());
                PhpUiUtil.show(editor);
                if (editor.isOK()) {
                    PhpConfigurationOptionsComponent.this.setConfigurationOptions(editor.getConfigurationOptions());
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpCommandSettings command = new PhpCommandSettings("", PhpCommandLinePathProcessor.LOCAL, null);
                command.addConfigurationOptions(PhpConfigurationOption.convert(PhpConfigurationOptionsComponent.this.getConfigurationOptionsData()));
                GeneralCommandLine generalCommandLine = command.createGeneralCommandLine();
                ParametersList parametersList = generalCommandLine.getParametersList();
                String parametersString = parametersList.getParametersString();
                PhpConfigurationOptionsComponent.this.setText(parametersString);
            }
        });
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher.addListener((EventListener)changeListener, (Disposable)this);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.removeListener((EventListener)changeListener);
    }

    public void dispose() {
    }

    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptionsData() {
        List<PhpConfigurationOptionData> list = PhpSdkAdditionalData.cloneConfigurationOptions(this.myConfigurationOptions);
        if (list == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(2);
        }
        return list;
    }

    public List<PhpConfigurationOption> getConfigurationOptions() {
        return PhpConfigurationOption.convert(this.getConfigurationOptionsData());
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpConfigurationOptionsComponent.$$$reportNull$$$0(3);
        }
        this.myConfigurationOptions = PhpSdkAdditionalData.cloneConfigurationOptions(configurationOptions);
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptionsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditor
    extends DialogWrapper {
        private final JComponent myMainPanel;
        private final TableView<PhpConfigurationOptionData> myConfigurationOptionsTable;

        private MyEditor(@NotNull JComponent parent, @NotNull List<PhpConfigurationOptionData> configurationOptions) {
            if (parent == null) {
                MyEditor.$$$reportNull$$$0(0);
            }
            if (configurationOptions == null) {
                MyEditor.$$$reportNull$$$0(1);
            }
            super((Component)parent, true);
            this.myConfigurationOptionsTable = new TableView(new ListTableModel(new ColumnInfo[]{new ColumnInfo<PhpConfigurationOptionData, String>(PhpBundle.message("PhpInterpreterConfigurable.configuration.options.table.name", new Object[0])){

                public String valueOf(PhpConfigurationOptionData configurationOption) {
                    return configurationOption.getName();
                }

                public boolean isCellEditable(PhpConfigurationOptionData configurationOption) {
                    return true;
                }

                public void setValue(PhpConfigurationOptionData configurationOption, String value) {
                    if (value.equals(this.valueOf(configurationOption))) {
                        return;
                    }
                    configurationOption.setName(value);
                }
            }, new ColumnInfo<PhpConfigurationOptionData, String>(PhpBundle.message("PhpInterpreterConfigurable.configuration.options.table.value", new Object[0])){

                public String valueOf(PhpConfigurationOptionData configurationOption) {
                    return configurationOption.getValue();
                }

                public boolean isCellEditable(PhpConfigurationOptionData configurationOption) {
                    return true;
                }

                public void setValue(PhpConfigurationOptionData configurationOption, String value) {
                    if (value.equals(this.valueOf(configurationOption))) {
                        return;
                    }
                    configurationOption.setValue(value);
                }
            }}));
            this.myMainPanel = ToolbarDecorator.createDecorator(this.myConfigurationOptionsTable, (ElementProducer)new ElementProducer<PhpConfigurationOptionData>(){

                public PhpConfigurationOptionData createElement() {
                    return new PhpConfigurationOptionData();
                }

                public boolean canCreateElement() {
                    return true;
                }
            }).createPanel();
            String emptyText = PhpBundle.message("PhpInterpreterConfigurable.configuration.options.table.empty.text", new Object[0]);
            this.myConfigurationOptionsTable.setRowHeight(new JTextField().getPreferredSize().height);
            this.myConfigurationOptionsTable.getEmptyText().setText(emptyText);
            this.myConfigurationOptionsTable.getListTableModel().setItems(configurationOptions);
            this.setTitle(PhpBundle.message("PhpInterpreterConfigurable.configuration.options.dialog.caption", new Object[0]));
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        @NotNull
        public List<PhpConfigurationOptionData> getConfigurationOptions() {
            List list = this.myConfigurationOptionsTable.getItems();
            if (list == null) {
                MyEditor.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent$MyEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpConfigurationOptionsComponent$MyEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

