/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectSharedConfiguration;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.servers.PhpProjectServersManager;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServersWorkspaceStateComponent;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpProjectConfigurationFacade {
    private final Object myLock;
    public static final String PHP_EXECUTABLE = SystemInfo.isWindows ? "php.exe" : "php";
    public static final String PHP_CGI = SystemInfo.isWindows ? "php-cgi.exe" : "php-cgi";
    private final Project myProject;

    public static PhpProjectConfigurationFacade getInstance(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(0);
        }
        return (PhpProjectConfigurationFacade)ServiceManager.getService((Project)project, PhpProjectConfigurationFacade.class);
    }

    public PhpProjectConfigurationFacade(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myProject = project;
    }

    public void fireStateChanged() {
        ((StateChangedListener)this.myProject.getMessageBus().syncPublisher(StateChangedListener.TOPIC)).stateChanged();
    }

    @Nullable
    public String getPhpHome() {
        PhpInterpreter interpreter = this.getInterpreter();
        return interpreter != null ? interpreter.getHomePath() : null;
    }

    @Nullable
    public PhpDebugExtension getInterpreterDebugExtension() {
        PhpInterpreter interpreter = this.getInterpreter();
        if (interpreter == null || StringUtil.isEmpty((String)interpreter.getDebuggerId())) {
            return null;
        }
        return PhpDebugUtil.getDebugExtensionByDebuggerId(interpreter.getDebuggerId());
    }

    @Nullable
    public PhpInterpreter getInterpreter() {
        String interpreterName = this.getProjectConfiguration().getInterpreterName();
        if (interpreterName != null) {
            return PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreter(interpreterName);
        }
        return null;
    }

    public void onSelectedInterpreterRename(@NotNull PhpInterpreterBasedConfig config, @Nullable String oldName, @Nullable String newName) {
        if (config == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(2);
        }
        String interpreterName = config.getInterpreterName();
        if (StringUtil.isNotEmpty((String)newName) && StringUtil.equals((CharSequence)interpreterName, (CharSequence)oldName)) {
            config.setInterpreterName(newName);
        }
        this.fireStateChanged();
    }

    public void updateSelectedInterpreterName(@Nullable String oldName, @Nullable String newName) {
        String interpreterName = this.getProjectConfiguration().getInterpreterName();
        if (StringUtil.isNotEmpty((String)newName) && StringUtil.equals((CharSequence)interpreterName, (CharSequence)oldName)) {
            this.getProjectConfiguration().setInterpreterName(newName);
        }
        this.fireStateChanged();
    }

    @Nullable
    public PhpInfo getPhpInfo() {
        PhpInterpreter interpreter = this.getInterpreter();
        if (interpreter != null) {
            String interpreterName = interpreter.getName();
            PhpInfo phpInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(interpreterName);
            if (phpInfo != null) {
                return phpInfo;
            }
        }
        return null;
    }

    public PhpProjectWorkspaceConfiguration.State getProjectConfiguration() {
        return ((PhpProjectWorkspaceConfiguration)ServiceManager.getService((Project)this.myProject, PhpProjectWorkspaceConfiguration.class)).getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServers(@NotNull List<PhpServer> servers) {
        if (servers == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.setServers(servers);
        }
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addServer(@NotNull PhpServer server, @NotNull String name) {
        if (server == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(5);
        }
        String serverName = name;
        int counter = 1;
        Object object = this.myLock;
        synchronized (object) {
            while (this.findServer(serverName) != null) {
                serverName = name + " (" + counter++ + ")";
            }
            server.setName(serverName);
            this.getServers().add(server);
        }
        this.fireStateChanged();
        return serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PhpServer findServer(@Nullable String serverName) {
        if (serverName == null) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            List<PhpServer> servers = this.getServers();
            for (PhpServer server : servers) {
                if (!serverName.equals(server.getName())) continue;
                return server;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PhpServer findServer(@NotNull String host, int serverPort) {
        if (host == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            for (PhpServer server : this.getServers()) {
                if (!server.equals(host, serverPort)) continue;
                return server;
            }
            return null;
        }
    }

    @NotNull
    public List<PhpServer> getServers() {
        List<PhpServer> list = this.getWorkspaceServersConfiguration().getServers();
        if (list == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setServers(@NotNull List<PhpServer> servers) {
        if (servers == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(8);
        }
        this.getWorkspaceServersConfiguration().setServers(servers);
    }

    public boolean isSharedServer(@NotNull PhpServer server) {
        if (server == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(9);
        }
        return this.getWorkspaceServersConfiguration().isConfigurationShared(server);
    }

    public void setSharedServer(@NotNull PhpServer server, boolean shared) {
        if (server == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(10);
        }
        this.getWorkspaceServersConfiguration().setConfigurationShared(server, shared);
    }

    @NotNull
    private PhpServersWorkspaceStateComponent getWorkspaceServersConfiguration() {
        PhpServersWorkspaceStateComponent serversManager = PhpServersWorkspaceStateComponent.getInstance(this.myProject);
        PhpProjectServersManager.getInstance(this.myProject);
        PhpServersWorkspaceStateComponent phpServersWorkspaceStateComponent = serversManager;
        if (phpServersWorkspaceStateComponent == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(11);
        }
        return phpServersWorkspaceStateComponent;
    }

    @NotNull
    private PhpProjectSharedConfiguration.State getProjectSharedConfiguration() {
        PhpProjectSharedConfiguration projectConfiguration = (PhpProjectSharedConfiguration)ServiceManager.getService((Project)this.myProject, PhpProjectSharedConfiguration.class);
        PhpProjectSharedConfiguration.State state = projectConfiguration.getState();
        if (state == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(12);
        }
        return state;
    }

    @NotNull
    public PhpLanguageLevel getLanguageLevel() {
        PhpLanguageLevel phpLanguageLevel = this.getProjectSharedConfiguration().getLanguageLevel();
        if (phpLanguageLevel == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(13);
        }
        return phpLanguageLevel;
    }

    public void setLanguageLevel(@NotNull PhpLanguageLevel languageLevel) {
        PhpProjectSharedConfiguration.State configuration;
        if (languageLevel == null) {
            PhpProjectConfigurationFacade.$$$reportNull$$$0(14);
        }
        if ((configuration = this.getProjectSharedConfiguration()).getLanguageLevel() != languageLevel) {
            configuration.setLanguageLevel(languageLevel);
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurationFacade";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurationFacade";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceServersConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSharedConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onSelectedInterpreterRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateServers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findServer";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setServers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSharedServer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSharedServer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface StateChangedListener {
        public static final Topic<StateChangedListener> TOPIC = Topic.create((String)"stateChanged", StateChangedListener.class);

        public void stateChanged();
    }
}

