/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.jetbrains.php.FrameworkBundle;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FrameworkWorkingFolderService {
    @NonNls
    private static final Logger LOG = Logger.getInstance(FrameworkWorkingFolderService.class);
    private String myWorkingFolder;

    private FrameworkWorkingFolderService(Project project, UltimateVerifier verifier) {
        PluginVerifier.verifyUltimatePlugin(verifier);
        String baseDir = project.getBasePath();
        LOG.assertTrue(baseDir != null);
        this.myWorkingFolder = FileUtilRt.toSystemDependentName((String)baseDir);
    }

    public static FrameworkWorkingFolderService getInstance(Project project) {
        return (FrameworkWorkingFolderService)ServiceManager.getService((Project)project, FrameworkWorkingFolderService.class);
    }

    public String getWorkingFolder() {
        return this.myWorkingFolder;
    }

    public void setWorkingFolder(String workingFolder) {
        this.myWorkingFolder = workingFolder;
    }

    public String handleChangeDirectoryCommand(String command) {
        String directoryToSet = FrameworkWorkingFolderService.getDirectoryToSet(command);
        String newDirectory = FrameworkWorkingFolderService.getNewCurrentDirectory(directoryToSet, this.getWorkingFolder());
        if (!StringUtil.isEmpty((String)newDirectory)) {
            this.setWorkingFolder(newDirectory);
            return FrameworkBundle.message("framework.current.directory.message.current.working.directory.is.0", newDirectory);
        }
        return FrameworkBundle.message("framework.directory.0.not.found", directoryToSet);
    }

    public static boolean isChangeDirectoryCommand(@NonNls String command) {
        return command.startsWith("cd");
    }

    @Nullable
    private static String getNewCurrentDirectory(String directoryToSet, String currentWorkingFolder) {
        if (directoryToSet == null) {
            return null;
        }
        if (!StringUtil.isEmpty((String)directoryToSet)) {
            File file;
            if (!FileUtil.isAbsolute((String)directoryToSet)) {
                directoryToSet = new File(currentWorkingFolder + File.separatorChar + directoryToSet).getAbsolutePath();
            }
            if ((file = new File(directoryToSet)).exists() && file.isDirectory()) {
                try {
                    return FileUtil.toSystemDependentName((String)file.getCanonicalPath());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return FileUtil.toSystemDependentName((String)file.getAbsolutePath());
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getDirectoryToSet(String command) {
        if (!FrameworkWorkingFolderService.isChangeDirectoryCommand(command)) {
            return null;
        }
        List elements = StringUtil.splitHonorQuotes((String)command, (char)' ');
        if (elements.size() == 1) {
            return "";
        }
        String directoryToSet = (String)elements.get(1);
        if (directoryToSet.contains("&")) {
            directoryToSet = (String)StringUtil.splitHonorQuotes((String)directoryToSet, (char)'&').get(0);
        }
        if (directoryToSet.contains("|")) {
            directoryToSet = (String)StringUtil.splitHonorQuotes((String)directoryToSet, (char)'|').get(0);
        }
        directoryToSet = StringUtil.unquoteString((String)directoryToSet);
        return directoryToSet;
    }
}

