/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import com.intellij.util.ObjectUtils;
import java.io.File;
import java.time.Instant;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.lock.Lock;

public class Info
extends BaseNodeDescription {
    public static final String SCHEDULE_ADD = "add";
    private static final Date DEFAULT_COMMITTED_DATE = Date.from(Instant.EPOCH);
    private final File myFile;
    private final String myPath;
    private final Url myURL;
    @NotNull
    private final Revision myRevision;
    private final Url myRepositoryRootURL;
    private final String myRepositoryUUID;
    private final Revision myCommittedRevision;
    private final Date myCommittedDate;
    private final String myAuthor;
    @Nullable
    private final Lock myLock;
    private final boolean myIsRemote;
    private final String mySchedule;
    private final Url myCopyFromURL;
    private final Revision myCopyFromRevision;
    @Nullable
    private final File myConflictOldFile;
    @Nullable
    private final File myConflictNewFile;
    @Nullable
    private final File myConflictWrkFile;
    @Nullable
    private final File myPropConflictFile;
    private final Depth myDepth;
    @Nullable
    private final TreeConflictDescription myTreeConflict;

    /*
     * WARNING - void declaration
     */
    public Info(File file, Url url, Url rootURL, long revision, @NotNull NodeKind kind, String uuid, long committedRevision, String committedDate, String author, String schedule, Url copyFromURL, long copyFromRevision, @Nullable String conflictOldFileName, @Nullable String conflictNewFileName, @Nullable String conflictWorkingFileName, @Nullable String propRejectFileName, @Nullable Lock lock, Depth depth, @Nullable TreeConflictDescription treeConflictDescription) {
        void depth2;
        void treeConflict;
        void lock2;
        if (kind == null) {
            Info.$$$reportNull$$$0(0);
        }
        super(kind);
        this.myFile = file;
        this.myURL = url;
        this.myRevision = Revision.of(revision);
        this.myRepositoryUUID = uuid;
        this.myRepositoryRootURL = rootURL;
        this.myCommittedRevision = Revision.of(committedRevision);
        this.myCommittedDate = committedDate != null ? (Date)ObjectUtils.notNull((Object)SvnUtil.parseDate(committedDate), (Object)DEFAULT_COMMITTED_DATE) : null;
        this.myAuthor = author;
        this.mySchedule = schedule;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = Revision.of(copyFromRevision);
        this.myLock = lock2;
        this.myTreeConflict = treeConflict;
        this.myConflictOldFile = Info.resolveConflictFile(file, conflictOldFileName);
        this.myConflictNewFile = Info.resolveConflictFile(file, conflictNewFileName);
        this.myConflictWrkFile = Info.resolveConflictFile(file, conflictWorkingFileName);
        this.myPropConflictFile = Info.resolveConflictFile(file, propRejectFileName);
        this.myIsRemote = false;
        this.myDepth = depth2;
        this.myPath = null;
    }

    /*
     * WARNING - void declaration
     */
    public Info(String path, Url url, @NotNull Revision revision, @NotNull NodeKind kind, String uuid, Url reposRootURL, long committedRevision, Date date, String author, @Nullable Lock lock, Depth depth) {
        void depth2;
        if (revision == null) {
            Info.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            Info.$$$reportNull$$$0(2);
        }
        super(kind);
        this.myIsRemote = true;
        this.myURL = url;
        this.myRevision = revision;
        this.myRepositoryRootURL = reposRootURL;
        this.myRepositoryUUID = uuid;
        this.myCommittedDate = date;
        this.myCommittedRevision = Revision.of(committedRevision);
        this.myAuthor = author;
        this.myLock = lock;
        this.myPath = path;
        this.myDepth = depth2;
        this.myFile = null;
        this.mySchedule = null;
        this.myCopyFromURL = null;
        this.myCopyFromRevision = null;
        this.myConflictOldFile = null;
        this.myConflictNewFile = null;
        this.myConflictWrkFile = null;
        this.myPropConflictFile = null;
        this.myTreeConflict = null;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public Revision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    @Nullable
    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    @Nullable
    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    @Nullable
    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    @Nullable
    public TreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public Revision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public Url getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            Info.$$$reportNull$$$0(3);
        }
        return nodeKind;
    }

    @Nullable
    public Lock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    @Nullable
    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public Url getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    @NotNull
    public Revision getRevision() {
        Revision revision = this.myRevision;
        if (revision == null) {
            Info.$$$reportNull$$$0(4);
        }
        return revision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public Url getURL() {
        return this.myURL;
    }

    public Depth getDepth() {
        return this.myDepth;
    }

    @Nullable
    private static File resolveConflictFile(@Nullable File file, @Nullable String path) {
        return file != null && path != null ? new File(file.getParentFile(), path) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/info/Info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/info/Info";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

