/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SetValueAction
extends AnAction
implements DumbAware,
GridAction {
    private final ReservedCellValue myValue;

    protected SetValueAction(ReservedCellValue value) {
        this.myValue = value;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetValueAction.$$$reportNull$$$0(0);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null || !grid.isEditable() || !grid.isReady()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        e.getPresentation().setEnabledAndVisible(selectionModel.getSelectedRowCount() >= 1 && selectionModel.getSelectedColumnCount() >= 1 && this.areSelectedColumnsAssignable(grid));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetValueAction.$$$reportNull$$$0(1);
        }
        if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) != null) {
            grid.cancelEditing();
            grid.setCells(grid.getSelectionModel().getSelectedRows(), grid.getSelectionModel().getSelectedColumns(), (Object)this.myValue);
        }
    }

    protected abstract boolean canSetValue(@NotNull DasColumn var1);

    public ReservedCellValue getValue() {
        return this.myValue;
    }

    private boolean areSelectedColumnsAssignable(@NotNull DataGrid grid) {
        if (grid == null) {
            SetValueAction.$$$reportNull$$$0(2);
        }
        List selectedColumns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(grid.getSelectionModel().getSelectedColumns());
        Condition notAssignable = column2 -> {
            DasColumn columnInfo;
            if (grid == null) {
                SetValueAction.$$$reportNull$$$0(3);
            }
            return (columnInfo = DataGridUtil.getDatabaseColumn(grid, column2)) == null || !this.canSetValue(columnInfo);
        };
        return JBIterable.from(selectedColumns).filter(notAssignable).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/SetValueAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "areSelectedColumnsAssignable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$areSelectedColumnsAssignable$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SetNullAction
    extends SetValueAction {
        public SetNullAction() {
            super(ReservedCellValue.NULL);
        }

        @Override
        protected boolean canSetValue(@NotNull DasColumn columnInfo) {
            if (columnInfo == null) {
                SetNullAction.$$$reportNull$$$0(0);
            }
            return !columnInfo.isNotNull();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/database/run/actions/SetValueAction$SetNullAction", "canSetValue"));
        }
    }

    public static class SetDefaultAction
    extends SetValueAction {
        public SetDefaultAction() {
            super(ReservedCellValue.DEFAULT);
        }

        @Override
        protected boolean canSetValue(@NotNull DasColumn columnInfo) {
            if (columnInfo == null) {
                SetDefaultAction.$$$reportNull$$$0(0);
            }
            return columnInfo.getDefault() != null || SetDefaultAction.dataTypeAcceptsDefault(columnInfo);
        }

        private static boolean dataTypeAcceptsDefault(@NotNull DasColumn dasColumn) {
            BasicElement column2;
            if (dasColumn == null) {
                SetDefaultAction.$$$reportNull$$$0(1);
            }
            if ((column2 = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)dasColumn), BasicTableColumn.class)) == null) {
                return false;
            }
            return DbImplUtil.getModelHelper(column2).gridColumnHasDefaultValue(column2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasColumn";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SetValueAction$SetDefaultAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canSetValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataTypeAcceptsDefault";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

