/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.util.ArrayUtilRt;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MariaJdbcHelper
extends MysqlBaseJdbcHelper {
    public MariaJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MariaDB", version, connection);
    }

    public MariaJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MariaJdbcHelper.extractVersion(version);
    }

    @Override
    public int getRow(@NotNull ResultSet rs) throws SQLException {
        Object pointer;
        if (rs == null) {
            MariaJdbcHelper.$$$reportNull$$$0(0);
        }
        if ((pointer = ReflectionHelper.tryInvokeMethod(rs, "getRowPointer", ArrayUtilRt.EMPTY_CLASS_ARRAY, ArrayUtilRt.EMPTY_OBJECT_ARRAY)) instanceof Integer) {
            return (Integer)pointer + 1;
        }
        return super.getRow(rs);
    }

    @NotNull
    protected static MariaJdbcHelper create(@NotNull Connection delegate, @Nullable String versionStr) {
        if (delegate == null) {
            MariaJdbcHelper.$$$reportNull$$$0(1);
        }
        String version = MariaJdbcHelper.extractVersion(versionStr);
        MariaJdbcHelper mariaJdbcHelper = new MariaJdbcHelper(version, delegate);
        if (mariaJdbcHelper == null) {
            MariaJdbcHelper.$$$reportNull$$$0(2);
        }
        return mariaJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MariaJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MariaJdbcHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

