/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.BProjectedCoordsP;

public class VCirShape
extends ClosedShape {
    Color shapeColor;
    Color shapebColor;
    boolean paintShapeBorder = true;
    boolean shapeFilled = true;
    long vs;
    BProjectedCoordsP[] pc;
    float[] vertices;

    public VCirShape(float[] v) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vs = 10L;
        this.vertices = v;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.setShapeColor(Color.red);
        this.setShapeBorderColor(Color.black);
    }

    public VCirShape(long x, long y, int z, long s, float[] v, Color cc, Color sc, Color cbc, Color sbc, float or) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.vertices = v;
        this.computeSize();
        this.orient = or;
        this.setColor(cc);
        this.setBorderColor(cbc);
        this.setShapeColor(sc);
        this.setShapeBorderColor(sbc);
    }

    public void initCams(int nbCam) {
        this.pc = new BProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new BProjectedCoordsP();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoordsP[] ta = this.pc;
                this.pc = new BProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new BProjectedCoordsP();
            } else {
                System.err.println("VCirShape:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new BProjectedCoordsP[1];
            this.pc[0] = new BProjectedCoordsP();
        } else {
            System.err.println("VCirShape:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return Math.sqrt(Math.pow(jpx - this.pc[camIndex].cx, 2.0) + Math.pow(jpy - this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) < (double)(dvr + this.vs);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        int[] xcoords = new int[this.vertices.length];
        int[] ycoords = new int[this.vertices.length];
        float vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            xcoords[j] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            ycoords[j] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        xcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        ycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(xcoords, ycoords, this.vertices.length);
        } else {
            for (j = 0; j < xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = xcoords[j];
                this.pc[i].p.ypoints[j] = ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        int[] xcoords = new int[this.vertices.length];
        int[] ycoords = new int[this.vertices.length];
        float vertexAngle = this.orient;
        for (j = 0; j < this.vertices.length - 1; ++j) {
            xcoords[j] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[j]);
            ycoords[j] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[j]);
            vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)this.vertices.length);
        }
        xcoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        ycoords[this.vertices.length - 1] = (int)Math.round((double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(vertexAngle) * (double)this.vertices[this.vertices.length - 1]);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(xcoords, ycoords, this.vertices.length);
        } else {
            for (j = 0; j < xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = xcoords[j];
                this.pc[i].lp.ypoints[j] = ycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
                }
            }
            if (this.shapeFilled) {
                g.setColor(this.shapeColor);
                g.fillPolygon(this.pc[i].p);
            }
            if (this.paintShapeBorder) {
                g.setColor(this.shapebColor);
                g.drawPolygon(this.pc[i].p);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
                }
            }
            if (this.shapeFilled) {
                g.setColor(this.shapeColor);
                g.fillPolygon(this.pc[i].lp);
            }
            if (this.paintShapeBorder) {
                g.setColor(this.shapebColor);
                g.drawPolygon(this.pc[i].lp);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Color getShapeColor() {
        return this.shapeColor;
    }

    public Color getShapeBorderColor() {
        return this.shapebColor;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public void setShapeColor(Color c) {
        this.shapeColor = c;
    }

    public void setShapeBorderColor(Color c) {
        this.shapebColor = c;
    }

    public void setShapeFilled(boolean b) {
        this.shapeFilled = b;
    }

    public void setDrawBorder(boolean b) {
        this.paintShapeBorder = b;
    }

    public Object clone() {
        VCirShape res = new VCirShape(this.vx, this.vy, 0, this.vs, this.vertices, this.color, this.shapeColor, this.bColor, this.shapebColor, this.orient);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }
}

