/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 23:17:53 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9792 $
//  type=mt

/**
 * Localized names for the "mt" locale.
 */
public class LocalizedNamesImpl_mt extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BD",
        "BB",
        "BS",
        "BH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BL",
        "BO",
        "BW",
        "BV",
        "BA",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "TD",
        "CX",
        "CL",
        "CN",
        "CY",
        "CC",
        "CK",
        "CP",
        "CW",
        "DK",
        "CD",
        "DG",
        "DM",
        "EA",
        "EG",
        "EC",
        "SV",
        "AE",
        "ER",
        "EE",
        "ET",
        "FK",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "JM",
        "GM",
        "GH",
        "JP",
        "DE",
        "GG",
        "GI",
        "DJ",
        "GW",
        "GQ",
        "GN",
        "JO",
        "GE",
        "GR",
        "GD",
        "GL",
        "GY",
        "GF",
        "GP",
        "GU",
        "GT",
        "AX",
        "FO",
        "KY",
        "MP",
        "MH",
        "SA",
        "HM",
        "IC",
        "IN",
        "ID",
        "GB",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IM",
        "IT",
        "IL",
        "JE",
        "YE",
        "KH",
        "CM",
        "CA",
        "CV",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "XK",
        "CR",
        "CI",
        "HR",
        "CU",
        "KW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "YT",
        "MY",
        "MW",
        "MV",
        "MD",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "ME",
        "MX",
        "MF",
        "FM",
        "MM",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "NL",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "CF",
        "CZ",
        "DO",
        "RE",
        "RS",
        "RO",
        "RU",
        "RW",
        "EH",
        "SH",
        "KN",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "LC",
        "ST",
        "SN",
        "SC",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "GS",
        "ES",
        "LK",
        "SS",
        "US",
        "SD",
        "SR",
        "SJ",
        "CH",
        "SZ",
        "SX",
        "TA",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "HU",
        "UM",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "ZM",
        "ZW",
        "SE",
        "HT",
        "HN",
        "HK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dinja");
    namesMap.put("002", "Affrika");
    namesMap.put("003", "Amerika ta’ Fuq");
    namesMap.put("005", "Amerika t’Isfel");
    namesMap.put("009", "Oċejanja");
    namesMap.put("011", "Affrika tal-Punent");
    namesMap.put("013", "Amerika Ċentrali");
    namesMap.put("014", "Affrika tal-Lvant");
    namesMap.put("015", "Affrika ta’ Fuq");
    namesMap.put("017", "Affrika Nofsani");
    namesMap.put("018", "Affrika t’Isfel");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika Nòrdiku");
    namesMap.put("029", "Karibew");
    namesMap.put("030", "Asja tal-Lvant");
    namesMap.put("034", "Asja t’Isfel Ċentrali");
    namesMap.put("035", "Asja tax-Xlokk");
    namesMap.put("039", "Ewropa t’Isfel");
    namesMap.put("053", "Awstralja u New Zealand");
    namesMap.put("054", "Melanesja");
    namesMap.put("057", "Reġjun ta’ Mikroneżja");
    namesMap.put("061", "Polinesja");
    namesMap.put("142", "Asja");
    namesMap.put("143", "Asja Ċentrali");
    namesMap.put("145", "Asja tal-Punent");
    namesMap.put("150", "Ewropa");
    namesMap.put("151", "Ewropa tal-Lvant");
    namesMap.put("154", "Ewropa ta’ Fuq");
    namesMap.put("155", "Ewropa tal-Punent");
    namesMap.put("419", "Amerika Latina");
    namesMap.put("AE", "Emirati Għarab Maqgħuda");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AI", "Angwilla");
    namesMap.put("AL", "Albanija");
    namesMap.put("AM", "Armenja");
    namesMap.put("AN", "Antilles Olandiżi");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AR", "Arġentina");
    namesMap.put("AS", "Samoa Amerikana");
    namesMap.put("AT", "Awstrija");
    namesMap.put("AU", "Awstralja");
    namesMap.put("AX", "Gżejjer Aland");
    namesMap.put("AZ", "Ażerbajġan");
    namesMap.put("BA", "Bożnija Ħerżegovina");
    namesMap.put("BD", "Bangladexx");
    namesMap.put("BE", "Belġju");
    namesMap.put("BG", "Bulgarija");
    namesMap.put("BH", "Baħrajn");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolivja");
    namesMap.put("BR", "Brażil");
    namesMap.put("BS", "Baħamas");
    namesMap.put("BT", "Butan");
    namesMap.put("BY", "Bjelorussja");
    namesMap.put("BZ", "Beliże");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Democratic Republic of the Congo");
    namesMap.put("CF", "Repubblika Afrikana Ċentrali");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Svizzera");
    namesMap.put("CI", "Kosta ta’ l-Avorju");
    namesMap.put("CL", "Ċili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Ċina");
    namesMap.put("CO", "Kolumbja");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kape Verde");
    namesMap.put("CY", "Ċipru");
    namesMap.put("CZ", "Repubblika Ċeka");
    namesMap.put("DE", "Ġermanja");
    namesMap.put("DJ", "Ġibuti");
    namesMap.put("DK", "Danimarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Republikka Domenikana");
    namesMap.put("DZ", "Alġerija");
    namesMap.put("EC", "Ekwador");
    namesMap.put("EE", "Estonja");
    namesMap.put("EG", "Eġittu");
    namesMap.put("EH", "Sahara tal-Punent");
    namesMap.put("ER", "Eritreja");
    namesMap.put("ES", "Spanja");
    namesMap.put("ET", "Etijopja");
    namesMap.put("EU", "Unjoni Ewropea");
    namesMap.put("FI", "Finlandja");
    namesMap.put("FJ", "Fiġi");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FM", "Mikronesja");
    namesMap.put("FO", "Gżejjer Faroe");
    namesMap.put("FR", "Franza");
    namesMap.put("GB", "Ingilterra");
    namesMap.put("GE", "Ġorġja");
    namesMap.put("GF", "Gujana Franċiża");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grinlandja");
    namesMap.put("GM", "Gambja");
    namesMap.put("GN", "Gineja");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginea Ekwatorjali");
    namesMap.put("GR", "Greċja");
    namesMap.put("GS", "South Georgia and the South Sandwich Islands");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginea-Bissaw");
    namesMap.put("GY", "Gujana");
    namesMap.put("HK", "Ħong Kong S.A.R. Ċina");
    namesMap.put("HM", "Heard Island and McDonald Islands");
    namesMap.put("HN", "Ħonduras");
    namesMap.put("HR", "Kroazja");
    namesMap.put("HT", "Ħaiti");
    namesMap.put("HU", "Ungerija");
    namesMap.put("ID", "Indoneżja");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IL", "Iżrael");
    namesMap.put("IN", "Indja");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italja");
    namesMap.put("JM", "Ġamajka");
    namesMap.put("JO", "Ġordan");
    namesMap.put("JP", "Ġappun");
    namesMap.put("KE", "Kenja");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komoros");
    namesMap.put("KP", "Koreja ta’ Fuq");
    namesMap.put("KR", "Koreja t’Isfel");
    namesMap.put("KW", "Kuwajt");
    namesMap.put("KY", "Gżejjer Kajmani");
    namesMap.put("KZ", "Każakstan");
    namesMap.put("LB", "Libanu");
    namesMap.put("LC", "Santa Luċija");
    namesMap.put("LR", "Liberja");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwanja");
    namesMap.put("LU", "Lussemburgu");
    namesMap.put("LV", "Latvja");
    namesMap.put("LY", "Libja");
    namesMap.put("MA", "Marokk");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Maldova");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Gżejjer ta’ Marshall");
    namesMap.put("MK", "Maċedonja");
    namesMap.put("MM", "Mjanmar");
    namesMap.put("MN", "Mongolja");
    namesMap.put("MO", "Macao S.A.R., China");
    namesMap.put("MP", "Gżejjer Marjana ta’ Fuq");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mawritanja");
    namesMap.put("MU", "Mawrizju");
    namesMap.put("MX", "Messiku");
    namesMap.put("MY", "Malasja");
    namesMap.put("MZ", "Możambik");
    namesMap.put("NA", "Namibja");
    namesMap.put("NE", "Niġer");
    namesMap.put("NG", "Niġerja");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Olanda");
    namesMap.put("NO", "Norveġja");
    namesMap.put("PF", "Polinesja Franċiża");
    namesMap.put("PG", "Papwa-Ginea Ġdida");
    namesMap.put("PH", "Filippini");
    namesMap.put("PL", "Polonja");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Territorju Palestinjan");
    namesMap.put("PT", "Portugall");
    namesMap.put("PY", "Paragwaj");
    namesMap.put("RO", "Rumanija");
    namesMap.put("RU", "Russja");
    namesMap.put("SA", "Għarabja Sawdita");
    namesMap.put("SE", "Żvezja");
    namesMap.put("SG", "Singapor");
    namesMap.put("SI", "Slovenja");
    namesMap.put("SK", "Slovakkja");
    namesMap.put("SO", "Somalja");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome and Principe");
    namesMap.put("SY", "Sirja");
    namesMap.put("SZ", "Sważiland");
    namesMap.put("TD", "Ċad");
    namesMap.put("TF", "Territorji Franċiżi ta’ Nofsinhar");
    namesMap.put("TH", "Tajlandja");
    namesMap.put("TJ", "Taġikistan");
    namesMap.put("TK", "Tokelaw");
    namesMap.put("TL", "Timor tal-Lvant");
    namesMap.put("TN", "Tuneż");
    namesMap.put("TR", "Turkija");
    namesMap.put("TT", "Trinidad u Tobago");
    namesMap.put("TW", "Tajwan");
    namesMap.put("TZ", "Tanżanija");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "United States Minor Outlying Islands");
    namesMap.put("US", "Stati Uniti");
    namesMap.put("UY", "Urugwaj");
    namesMap.put("UZ", "Użbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent and the Grenadines");
    namesMap.put("VE", "Venezwela");
    namesMap.put("VN", "Vjetnam");
    namesMap.put("VU", "Vanwatu");
    namesMap.put("YE", "Jemen");
    namesMap.put("YT", "Majotte");
    namesMap.put("ZA", "Afrika t’Isfel");
    namesMap.put("ZM", "Żambja");
    namesMap.put("ZW", "Żimbabwe");
    namesMap.put("ZZ", "Reġjun Mhux Magħruf");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dinja",
        "002": "Affrika",
        "003": "Amerika ta’ Fuq",
        "005": "Amerika t’Isfel",
        "009": "Oċejanja",
        "011": "Affrika tal-Punent",
        "013": "Amerika Ċentrali",
        "014": "Affrika tal-Lvant",
        "015": "Affrika ta’ Fuq",
        "017": "Affrika Nofsani",
        "018": "Affrika t’Isfel",
        "019": "Amerika",
        "021": "Amerika Nòrdiku",
        "029": "Karibew",
        "030": "Asja tal-Lvant",
        "034": "Asja t’Isfel Ċentrali",
        "035": "Asja tax-Xlokk",
        "039": "Ewropa t’Isfel",
        "053": "Awstralja u New Zealand",
        "054": "Melanesja",
        "057": "Reġjun ta’ Mikroneżja",
        "061": "Polinesja",
        "142": "Asja",
        "143": "Asja Ċentrali",
        "145": "Asja tal-Punent",
        "150": "Ewropa",
        "151": "Ewropa tal-Lvant",
        "154": "Ewropa ta’ Fuq",
        "155": "Ewropa tal-Punent",
        "419": "Amerika Latina",
        "AE": "Emirati Għarab Maqgħuda",
        "AF": "Afganistan",
        "AI": "Angwilla",
        "AL": "Albanija",
        "AM": "Armenja",
        "AN": "Antilles Olandiżi",
        "AQ": "Antartika",
        "AR": "Arġentina",
        "AS": "Samoa Amerikana",
        "AT": "Awstrija",
        "AU": "Awstralja",
        "AX": "Gżejjer Aland",
        "AZ": "Ażerbajġan",
        "BA": "Bożnija Ħerżegovina",
        "BD": "Bangladexx",
        "BE": "Belġju",
        "BG": "Bulgarija",
        "BH": "Baħrajn",
        "BN": "Brunej",
        "BO": "Bolivja",
        "BR": "Brażil",
        "BS": "Baħamas",
        "BT": "Butan",
        "BY": "Bjelorussja",
        "BZ": "Beliże",
        "CA": "Kanada",
        "CD": "Democratic Republic of the Congo",
        "CF": "Repubblika Afrikana Ċentrali",
        "CG": "Kongo",
        "CH": "Svizzera",
        "CI": "Kosta ta’ l-Avorju",
        "CL": "Ċili",
        "CM": "Kamerun",
        "CN": "Ċina",
        "CO": "Kolumbja",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Kape Verde",
        "CY": "Ċipru",
        "CZ": "Repubblika Ċeka",
        "DE": "Ġermanja",
        "DJ": "Ġibuti",
        "DK": "Danimarka",
        "DM": "Dominika",
        "DO": "Republikka Domenikana",
        "DZ": "Alġerija",
        "EC": "Ekwador",
        "EE": "Estonja",
        "EG": "Eġittu",
        "EH": "Sahara tal-Punent",
        "ER": "Eritreja",
        "ES": "Spanja",
        "ET": "Etijopja",
        "EU": "Unjoni Ewropea",
        "FI": "Finlandja",
        "FJ": "Fiġi",
        "FK": "Falkland Islands",
        "FM": "Mikronesja",
        "FO": "Gżejjer Faroe",
        "FR": "Franza",
        "GB": "Ingilterra",
        "GE": "Ġorġja",
        "GF": "Gujana Franċiża",
        "GH": "Gana",
        "GL": "Grinlandja",
        "GM": "Gambja",
        "GN": "Gineja",
        "GP": "Gwadelupe",
        "GQ": "Ginea Ekwatorjali",
        "GR": "Greċja",
        "GS": "South Georgia and the South Sandwich Islands",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Ginea-Bissaw",
        "GY": "Gujana",
        "HK": "Ħong Kong S.A.R. Ċina",
        "HM": "Heard Island and McDonald Islands",
        "HN": "Ħonduras",
        "HR": "Kroazja",
        "HT": "Ħaiti",
        "HU": "Ungerija",
        "ID": "Indoneżja",
        "IE": "Irlanda",
        "IL": "Iżrael",
        "IN": "Indja",
        "IS": "Islanda",
        "IT": "Italja",
        "JM": "Ġamajka",
        "JO": "Ġordan",
        "JP": "Ġappun",
        "KE": "Kenja",
        "KG": "Kirgistan",
        "KH": "Kambodja",
        "KM": "Komoros",
        "KP": "Koreja ta’ Fuq",
        "KR": "Koreja t’Isfel",
        "KW": "Kuwajt",
        "KY": "Gżejjer Kajmani",
        "KZ": "Każakstan",
        "LB": "Libanu",
        "LC": "Santa Luċija",
        "LR": "Liberja",
        "LS": "Lesoto",
        "LT": "Litwanja",
        "LU": "Lussemburgu",
        "LV": "Latvja",
        "LY": "Libja",
        "MA": "Marokk",
        "MC": "Monako",
        "MD": "Maldova",
        "MG": "Madagaskar",
        "MH": "Gżejjer ta’ Marshall",
        "MK": "Maċedonja",
        "MM": "Mjanmar",
        "MN": "Mongolja",
        "MO": "Macao S.A.R., China",
        "MP": "Gżejjer Marjana ta’ Fuq",
        "MQ": "Martinik",
        "MR": "Mawritanja",
        "MU": "Mawrizju",
        "MX": "Messiku",
        "MY": "Malasja",
        "MZ": "Możambik",
        "NA": "Namibja",
        "NE": "Niġer",
        "NG": "Niġerja",
        "NI": "Nikaragwa",
        "NL": "Olanda",
        "NO": "Norveġja",
        "PF": "Polinesja Franċiża",
        "PG": "Papwa-Ginea Ġdida",
        "PH": "Filippini",
        "PL": "Polonja",
        "PN": "Pitcairn",
        "PS": "Territorju Palestinjan",
        "PT": "Portugall",
        "PY": "Paragwaj",
        "RO": "Rumanija",
        "RU": "Russja",
        "SA": "Għarabja Sawdita",
        "SE": "Żvezja",
        "SG": "Singapor",
        "SI": "Slovenja",
        "SK": "Slovakkja",
        "SO": "Somalja",
        "SR": "Surinam",
        "ST": "Sao Tome and Principe",
        "SY": "Sirja",
        "SZ": "Sważiland",
        "TD": "Ċad",
        "TF": "Territorji Franċiżi ta’ Nofsinhar",
        "TH": "Tajlandja",
        "TJ": "Taġikistan",
        "TK": "Tokelaw",
        "TL": "Timor tal-Lvant",
        "TN": "Tuneż",
        "TR": "Turkija",
        "TT": "Trinidad u Tobago",
        "TW": "Tajwan",
        "TZ": "Tanżanija",
        "UA": "Ukraina",
        "UM": "United States Minor Outlying Islands",
        "US": "Stati Uniti",
        "UY": "Urugwaj",
        "UZ": "Użbekistan",
        "VA": "Vatikan",
        "VC": "Saint Vincent and the Grenadines",
        "VE": "Venezwela",
        "VN": "Vjetnam",
        "VU": "Vanwatu",
        "YE": "Jemen",
        "YT": "Majotte",
        "ZA": "Afrika t’Isfel",
        "ZM": "Żambja",
        "ZW": "Żimbabwe",
        "ZZ": "Reġjun Mhux Magħruf"
    };
  }-*/;
}
