/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import com.google.gwt.core.server.StackTraceDeobfuscator;
import com.google.gwt.logging.server.JsonLogRecordServerUtil;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteLoggingServiceUtil {
    public static void logOnServer(LogRecord lr, String strongName, StackTraceDeobfuscator deobfuscator, String loggerNameOverride) throws RemoteLoggingException {
        if (deobfuscator != null) {
            lr = RemoteLoggingServiceUtil.deobfuscateLogRecord(deobfuscator, lr, strongName);
        }
        String loggerName = loggerNameOverride == null ? lr.getLoggerName() : loggerNameOverride;
        Logger logger = Logger.getLogger(loggerName);
        logger.log(lr);
    }

    public static LogRecord deobfuscateLogRecord(StackTraceDeobfuscator deobfuscator, LogRecord lr, String strongName) {
        if (lr.getThrown() != null && strongName != null) {
            deobfuscator.deobfuscateStackTrace(lr.getThrown(), strongName);
        }
        return lr;
    }

    public static void logOnServer(String serializedLogRecordJson, String strongName, StackTraceDeobfuscator deobfuscator, String loggerNameOverride) throws RemoteLoggingException {
        try {
            LogRecord lr = JsonLogRecordServerUtil.logRecordFromJson(serializedLogRecordJson);
            RemoteLoggingServiceUtil.logOnServer(lr, strongName, deobfuscator, loggerNameOverride);
        }
        catch (Exception e) {
            throw new RemoteLoggingException("Failed to deserialize JSON", e);
        }
    }

    public static class RemoteLoggingException
    extends Exception {
        public RemoteLoggingException(String message) {
            super(message);
        }

        public RemoteLoggingException(String message, Throwable t) {
            super(message, t);
        }
    }
}

