/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.ProblemDefinition;

@NonNullApi
public class DefaultProblemDefinition
implements Serializable,
ProblemDefinition {
    private final ProblemId id;
    private final Severity severity;
    private final DocLink documentationLink;

    @VisibleForTesting
    DefaultProblemDefinition(ProblemId id, Severity severity, @Nullable DocLink documentationUrl) {
        this.id = id;
        this.severity = severity;
        this.documentationLink = documentationUrl;
    }

    @Override
    public ProblemId getId() {
        return this.id;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public DocLink getDocumentationLink() {
        return this.documentationLink;
    }

    private static boolean equals(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProblemDefinition that = (DefaultProblemDefinition)o;
        return this.severity == that.severity && DefaultProblemDefinition.equals(this.id, that.id) && DefaultProblemDefinition.equals(this.documentationLink, that.documentationLink);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.id, this.severity, this.documentationLink});
    }
}

