/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import javax.swing.JOptionPane;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gui.Clock;
import net.sf.gogui.gui.CommandThread;
import net.sf.gogui.utils.StringUtils;

public final class Utils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Node createNode(Node node, Move move, Clock clock) {
        Node node2 = new Node(move);
        if (clock != null && clock.isInitialized()) {
            if (!$assertionsDisabled && clock.isRunning()) {
                throw new AssertionError();
            }
            GoColor goColor = move.getColor();
            long l = clock.getTimeLeft(goColor) / 1000L;
            if (goColor == GoColor.BLACK) {
                node2.setTimeLeftBlack(l);
                if (clock.isInByoyomi(goColor)) {
                    node2.setMovesLeftBlack(clock.getMovesLeft(goColor));
                }
            } else {
                if (!$assertionsDisabled && goColor != GoColor.WHITE) {
                    throw new AssertionError();
                }
                node2.setTimeLeftWhite(l);
                if (clock.isInByoyomi(goColor)) {
                    node2.setMovesLeftWhite(clock.getMovesLeft(goColor));
                }
            }
        }
        node.append(node2);
        return node2;
    }

    public static void sendKomi(Component component, double d, String string, CommandThread commandThread) {
        if (commandThread == null) {
            return;
        }
        try {
            if (commandThread.isCommandSupported("komi")) {
                commandThread.send("komi " + GameInformation.roundKomi(d));
            }
        }
        catch (GtpError gtpError) {
            Utils.showError(component, string, gtpError);
        }
    }

    public static void sendRules(int n, CommandThread commandThread) {
        if (commandThread == null || n == 0 || !commandThread.isCommandSupported("scoring_system")) {
            return;
        }
        try {
            String string = n == 2 ? "territory" : "area";
            commandThread.send("scoring_system " + string);
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public static void showError(Component component, String string, GtpError gtpError) {
        String string2 = gtpError.getMessage().trim();
        string2 = string2.length() == 0 ? "Command failed" : StringUtils.capitalize(string2);
        String string3 = "Error";
        if (string != null) {
            string3 = string3 + " - " + string;
        }
        JOptionPane.showMessageDialog(component, string2, string3, 0);
    }

    private Utils() {
    }

    static {
        $assertionsDisabled = !Utils.class.desiredAssertionStatus();
    }
}

