.TH FBNORM 1 25-Jun-90
.CM 3
.SH NAME
fbnorm \- normalize and adjust grayscale or color image
.SH SYNOPSIS
.nf
fbnorm [ -b<val> -w<val> ] [ -<type> ] < image > image
.fi
.SH DESCRIPTION
.PP
Extends the contrast range to a full 0 to 255.  The arguments
.B -b
and
.B -w
given the percentage of the darkest pixels to map to black and lightest
pixels to map to white.
.sp
For color images the default is to discard 0.5% each of the darkest and
lightest pixels.  Increasing the contrast beyond that may result in
significant color artifacts (because the color values will be partially
clipped).
.SH OPTIONS
.TP
.BR -b<num>, -w<num>
.I percentage black, white
pixels to map to 0, 255.  The default for grayscale images is to
"discard" 2 percent of the black pixels and 1 percent of the white
pixels.  For color images both values default to 0.5 percent.
.sp
An alternate form is to specify two integers, which will then be
linearly mapped to 0 and 255.
.SH EXAMPLE
.PP
To normalize a grayscale FBM image using defaults:
.sp
    % fbnorm < foo.fbm > bar.fbm
.sp
To increase contrast by discarding 10 percent of the black pixels and 5
percent of the white pixels:
.sp
    % fbnorm -b10 -w5 < foo.fbm > bar.fbm
.sp
Or, if you know that you want 34 to map to 0 and 197 to map to 255, you
can just type:
.sp
    % fbnorm 34 197 < foo.fbm > bar.fbm
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
