/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.xml.util.StringSplitter;
import org.relaxng.datatype.ValidationContext;

class ListDatatype
extends DatatypeBase
implements Measure {
    private final DatatypeBase itemType;

    ListDatatype(DatatypeBase itemType) {
        this.itemType = itemType;
    }

    Object getValue(String str, ValidationContext vc) {
        String[] tokens = StringSplitter.split(str);
        Object[] items = new Object[tokens.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.itemType.getValue(tokens[i], vc);
            if (items[i] != null) continue;
            return null;
        }
        return items;
    }

    boolean lexicallyAllows(String str) {
        String[] tokens = StringSplitter.split(str);
        for (int i = 0; i < tokens.length; ++i) {
            if (this.itemType.lexicallyAllows(tokens[i])) continue;
            return false;
        }
        return true;
    }

    boolean allowsValue(String str, ValidationContext vc) {
        String[] tokens = StringSplitter.split(str);
        for (int i = 0; i < tokens.length; ++i) {
            if (this.itemType.allowsValue(tokens[i], vc)) continue;
            return false;
        }
        return true;
    }

    Measure getMeasure() {
        return this;
    }

    public int getLength(Object obj) {
        return ((Object[])obj).length;
    }

    public boolean isContextDependent() {
        return this.itemType.isContextDependent();
    }

    public int getIdType() {
        if (this.itemType.getIdType() == 2) {
            return 3;
        }
        return 0;
    }

    public int valueHashCode(Object obj) {
        Object[] items = (Object[])obj;
        int hc = 0;
        for (int i = 0; i < items.length; ++i) {
            hc ^= this.itemType.valueHashCode(items[i]);
        }
        return hc;
    }

    public boolean sameValue(Object obj1, Object obj2) {
        Object[] items1 = (Object[])obj1;
        Object[] items2 = (Object[])obj2;
        if (items1.length != items2.length) {
            return false;
        }
        for (int i = 0; i < items1.length; ++i) {
            if (this.itemType.sameValue(items1[i], items2[i])) continue;
            return false;
        }
        return true;
    }
}

