/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.watcher;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class PutWatchRequest
extends MasterNodeRequest<PutWatchRequest> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(PutWatchRequest.class));
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");
    private String id;
    private BytesReference source;
    private XContentType xContentType = XContentType.JSON;
    private boolean active = true;
    private long version = -3L;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public PutWatchRequest() {
    }

    public PutWatchRequest(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public PutWatchRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public PutWatchRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    public PutWatchRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    public long getIfSeqNo() {
        return this.ifSeqNo;
    }

    public long getIfPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!PutWatchRequest.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"watch source is missing", (ActionRequestValidationException)validationException);
        }
        if (this.xContentType == null) {
            validationException = ValidateActions.addValidationError((String)"request body is missing", (ActionRequestValidationException)validationException);
        }
        if (this.ifSeqNo != -2L && this.version != -3L) {
            validationException = ValidateActions.addValidationError((String)"compare and write operations can not use versioning", (ActionRequestValidationException)validationException);
        }
        if (this.version != -3L) {
            DEPRECATION_LOGGER.deprecated("Usage of internal versioning for optimistic concurrency control is deprecated and will be removed. Please use the `if_seq_no` and `if_primary_term` parameters instead.", new Object[0]);
        }
        if (this.ifPrimaryTerm == 0L && this.ifSeqNo != -2L) {
            validationException = ValidateActions.addValidationError((String)"ifSeqNo is set, but primary term is [0]", (ActionRequestValidationException)validationException);
        }
        if (this.ifPrimaryTerm != 0L && this.ifSeqNo == -2L) {
            validationException = ValidateActions.addValidationError((String)("ifSeqNo is unassigned, but primary term is [" + this.ifPrimaryTerm + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.active = in.readBoolean();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? (XContentType)in.readEnum(XContentType.class) : XContentHelper.xContentType((BytesReference)this.source);
        this.version = in.getVersion().onOrAfter(Version.V_6_3_0) ? in.readZLong() : -3L;
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.ifSeqNo = in.readZLong();
            this.ifPrimaryTerm = in.readVLong();
        } else {
            this.ifSeqNo = -2L;
            this.ifPrimaryTerm = 0L;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeBoolean(this.active);
        if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
            out.writeEnum((Enum)this.xContentType);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeZLong(this.version);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeZLong(this.ifSeqNo);
            out.writeVLong(this.ifPrimaryTerm);
        }
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty((CharSequence)id) && NO_WS_PATTERN.matcher(id).matches();
    }
}

