/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class Foldables {
    public static <T> T valueOf(Expression e, DataType to) {
        if (e.foldable()) {
            return (T)DataTypeConversion.conversionFor(e.dataType(), to).convert(e.fold());
        }
        throw new SqlIllegalArgumentException("Cannot determine value for {}", e);
    }

    public static Object valueOf(Expression e) {
        if (e.foldable()) {
            return e.fold();
        }
        throw new SqlIllegalArgumentException("Cannot determine value for {}", e);
    }

    public static Integer intValueOf(Expression e) {
        return (Integer)Foldables.valueOf(e, DataType.INTEGER);
    }

    public static double doubleValueOf(Expression e) {
        return (Double)Foldables.valueOf(e, DataType.DOUBLE);
    }

    public static <T> List<T> valuesOf(List<Expression> list, DataType to) {
        return Foldables.foldTo(list, to, new ArrayList(list.size()));
    }

    public static <T> Set<T> valuesOfNoDuplicates(List<Expression> list, DataType to) {
        return Foldables.foldTo(list, to, new LinkedHashSet(list.size()));
    }

    private static <T, C extends Collection<T>> C foldTo(Collection<Expression> expressions, DataType to, C values) {
        for (Expression e : expressions) {
            values.add(Foldables.valueOf(e, to));
        }
        return values;
    }

    public static List<Double> doubleValuesOf(List<Expression> list) {
        return Foldables.valuesOf(list, DataType.DOUBLE);
    }
}

