/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.grouping.GroupSelector;

public class AllGroupsCollector<T>
extends SimpleCollector {
    private final GroupSelector<T> groupSelector;
    private final Set<T> groups = new HashSet<T>();

    public AllGroupsCollector(GroupSelector<T> groupSelector) {
        this.groupSelector = groupSelector;
    }

    public int getGroupCount() {
        return this.getGroups().size();
    }

    public Collection<T> getGroups() {
        return this.groups;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.groupSelector.setNextReader(context);
    }

    public void collect(int doc) throws IOException {
        this.groupSelector.advanceTo(doc);
        if (this.groups.contains(this.groupSelector.currentValue())) {
            return;
        }
        this.groups.add(this.groupSelector.copyValue());
    }

    public boolean needsScores() {
        return false;
    }
}

