/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.SampleFileIt;
import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.Data;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.MarkerIndices;
import vcf.RefGT;
import vcf.Samples;
import vcf.Window;
import vcf.WindowIt;

public class TargetData
implements Data {
    private final Pedigree ped;
    private int window = 0;
    private Window<GTRec> currentWindow;
    private GTRec[] recs;
    private GT gt;
    private MarkerIndices markerIndices;
    private final WindowIt<GTRec> targWindowIt;
    private int cumMarkerCnt = 0;

    public static TargetData targetData(Par par, Supplier<SampleFileIt<GTRec>> supplier) {
        GeneticMap geneticMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        WindowIt<GTRec> windowIt = WindowIt.newInstance(supplier, geneticMap, par.window(), par.overlap());
        TargetData targetData = new TargetData(par, windowIt);
        assert (targetData.canAdvanceWindow());
        targetData.advanceWindow();
        return targetData;
    }

    private TargetData(Par par, WindowIt<GTRec> windowIt) {
        this.ped = new Pedigree(windowIt.samples(), par.ped());
        this.targWindowIt = windowIt;
        this.currentWindow = null;
        this.recs = new GTRec[0];
        this.gt = TargetData.targGT(windowIt.samples(), this.recs, this.ped);
        this.markerIndices = null;
    }

    private static GT targGT(Samples samples, GTRec[] gTRecArray, Pedigree pedigree) {
        return new BasicGT(samples, gTRecArray);
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.targWindowIt.genMap();
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.currentWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.targWindowIt.hasNext();
    }

    @Override
    public void advanceWindow() {
        this.currentWindow = this.targWindowIt.next();
        this.cumMarkerCnt += this.currentWindow.nMarkers() - this.currentWindow.prevOverlap();
        this.recs = this.currentWindow.recList().toArray(new GTRec[0]);
        this.gt = TargetData.targGT(this.targWindowIt.samples(), this.recs, this.ped);
        this.markerIndices = new MarkerIndices(this.currentWindow.prevOverlap(), this.currentWindow.nextOverlap(), this.gt.nMarkers());
        ++this.window;
    }

    @Override
    public IntArray[][] carriers(int n2) {
        return (IntArray[][])((Stream)Arrays.stream(this.recs).parallel()).map(gTRec -> TargetData.carriers(gTRec, n2)).toArray(n -> new IntArray[n][]);
    }

    private static IntArray[] carriers(GTRec gTRec, int n2) {
        int n3 = gTRec.marker().nAlleles();
        IntList[] intListArray = (IntList[])IntStream.range(0, n3).mapToObj(n -> new IntList(16)).toArray(IntList[]::new);
        int n4 = gTRec.samples().size();
        for (int i = 0; i < n4; ++i) {
            int n5 = gTRec.allele1(i);
            int n6 = gTRec.allele2(i);
            if (n5 >= 0 && intListArray[n5].size() <= n2) {
                intListArray[n5].add(i);
            }
            if (n6 < 0 || n6 == n5 || intListArray[n6].size() > n2) continue;
            intListArray[n6].add(i);
        }
        return (IntArray[])Arrays.stream(intListArray).map(intList -> {
            if (intList.isEmpty()) {
                return Data.ZERO_FREQ_ARRAY;
            }
            if (intList.size() <= n2) {
                return new WrappedIntArray((IntList)intList);
            }
            return Data.HIGH_FREQ_ARRAY;
        }).toArray(IntArray[]::new);
    }

    @Override
    public int windowIndex() {
        return this.window;
    }

    @Override
    public int nTargMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public int nMarkers() {
        return this.gt.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public GT targGT() {
        return this.gt;
    }

    @Override
    public Optional<RefGT> refGT() {
        return Optional.empty();
    }

    @Override
    public Optional<RefGT> restrictRefGT() {
        return Optional.empty();
    }

    @Override
    public void close() {
        this.targWindowIt.close();
    }

    @Override
    public MarkerIndices markerIndices() {
        return this.markerIndices;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.NonRefData");
        return stringBuilder.toString();
    }
}

