/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import vcf.GTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class BasicGTRec
implements GTRec {
    private final Marker marker;
    private final Samples samples;
    private final int[] alleles;
    private final boolean[] isPhased;
    private final boolean allPhased;

    public BasicGTRec(VcfRecGTParser vcfRecGTParser) {
        int n = vcfRecGTParser.samples().size();
        int n2 = n << 1;
        int[] nArray = new int[n2];
        boolean[] blArray = new boolean[n];
        this.allPhased = vcfRecGTParser.storeAlleles(nArray, blArray);
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.alleles = nArray;
        this.isPhased = blArray;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return 2 * this.samples.size();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return this.allPhased;
    }

    @Override
    public boolean isPhased(int n) {
        return this.isPhased[n];
    }

    @Override
    public int allele1(int n) {
        return this.alleles[n << 1];
    }

    @Override
    public int allele2(int n) {
        return this.alleles[n << 1 | 1];
    }

    @Override
    public int get(int n) {
        return this.alleles[n];
    }

    @Override
    public int[] alleles() {
        return (int[])this.alleles.clone();
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }
}

