/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.activemq.apollo.openwire.command.ActiveMQMessage;
import org.apache.activemq.apollo.openwire.command.Message;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.blob.BlobUploader;
import org.fusesource.hawtbuf.UTF8Buffer;

public class ActiveMQBlobMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 29;
    public static final UTF8Buffer BINARY_MIME_TYPE = new UTF8Buffer("application/octet-stream");
    private UTF8Buffer remoteBlobUrl;
    private UTF8Buffer mimeType;
    private UTF8Buffer name;
    private boolean deletedByBroker;
    private transient BlobUploader blobUploader;
    private transient URL url;

    public Message copy() {
        ActiveMQBlobMessage copy = new ActiveMQBlobMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQBlobMessage copy) {
        super.copy(copy);
        copy.setRemoteBlobUrl(this.getRemoteBlobUrl());
        copy.setMimeType(this.getMimeType());
        copy.setDeletedByBroker(this.isDeletedByBroker());
        copy.setBlobUploader(this.getBlobUploader());
        copy.setName(this.getName());
    }

    public byte getDataStructureType() {
        return 29;
    }

    public UTF8Buffer getRemoteBlobUrl() {
        return this.remoteBlobUrl;
    }

    public void setRemoteBlobUrl(UTF8Buffer remoteBlobUrl) {
        this.remoteBlobUrl = remoteBlobUrl;
        this.url = null;
    }

    public UTF8Buffer getMimeType() {
        if (this.mimeType == null) {
            return BINARY_MIME_TYPE;
        }
        return this.mimeType;
    }

    public void setMimeType(UTF8Buffer mimeType) {
        this.mimeType = mimeType;
    }

    public UTF8Buffer getName() {
        return this.name;
    }

    public void setName(UTF8Buffer name) {
        this.name = name;
    }

    public boolean isDeletedByBroker() {
        return this.deletedByBroker;
    }

    public void setDeletedByBroker(boolean deletedByBroker) {
        this.deletedByBroker = deletedByBroker;
    }

    public UTF8Buffer getJMSXMimeType() {
        return this.getMimeType();
    }

    public InputStream getInputStream() throws IOException, OpenwireException {
        URL value = this.getURL();
        if (value == null) {
            return null;
        }
        return value.openStream();
    }

    public URL getURL() throws OpenwireException {
        if (this.url == null && this.remoteBlobUrl != null) {
            try {
                this.url = new URL(this.remoteBlobUrl.toString());
            }
            catch (MalformedURLException e) {
                throw new OpenwireException(e);
            }
        }
        return this.url;
    }

    public void setURL(URL url) {
        this.url = url;
        this.remoteBlobUrl = url != null ? new UTF8Buffer(url.toExternalForm()) : null;
    }

    public BlobUploader getBlobUploader() {
        return this.blobUploader;
    }

    public void setBlobUploader(BlobUploader blobUploader) {
        this.blobUploader = blobUploader;
    }

    public void onSend() throws OpenwireException {
        super.onSend();
        if (this.blobUploader != null) {
            try {
                URL value = this.blobUploader.upload(this);
                this.setURL(value);
            }
            catch (IOException e) {
                throw new OpenwireException(e);
            }
        }
    }
}

