/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.util.NameMap;
import org.apache.calcite.util.NameMultimap;
import org.apache.calcite.util.NameSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleCalciteSchema
extends CalciteSchema {
    SimpleCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name) {
        this(parent, schema, name, null, null, null, null, null, null, null, null);
    }

    private SimpleCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name, @Nullable NameMap<CalciteSchema> subSchemaMap, @Nullable NameMap<CalciteSchema.TableEntry> tableMap, @Nullable NameMap<CalciteSchema.LatticeEntry> latticeMap, @Nullable NameMap<CalciteSchema.TypeEntry> typeMap, @Nullable NameMultimap<CalciteSchema.FunctionEntry> functionMap, @Nullable NameSet functionNames, @Nullable NameMap<CalciteSchema.FunctionEntry> nullaryFunctionMap, @Nullable List<? extends List<String>> path) {
        super(parent, schema, name, subSchemaMap, tableMap, latticeMap, typeMap, functionMap, functionNames, nullaryFunctionMap, path);
    }

    @Override
    public void setCache(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        SimpleCalciteSchema calciteSchema = new SimpleCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected @Nullable CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        Schema s = this.schema.getSubSchema(schemaName);
        if (s != null) {
            return new SimpleCalciteSchema(this, s, schemaName);
        }
        return null;
    }

    @Override
    protected @Nullable CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        Table table = this.schema.getTable(tableName);
        if (table != null) {
            return this.tableEntry(tableName, table);
        }
        return null;
    }

    @Override
    protected @Nullable CalciteSchema.TypeEntry getImplicitType(String name, boolean caseSensitive) {
        RelProtoDataType type = this.schema.getType(name);
        if (type != null) {
            return this.typeEntry(name, type);
        }
        return null;
    }

    @Override
    protected void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> builder) {
        ImmutableSortedMap explicitSubSchemas = builder.build();
        for (String schemaName : this.schema.getSubSchemaNames()) {
            Schema s;
            if (explicitSubSchemas.containsKey((Object)schemaName) || (s = this.schema.getSubSchema(schemaName)) == null) continue;
            SimpleCalciteSchema calciteSchema = new SimpleCalciteSchema(this, s, schemaName);
            builder.put((Object)schemaName, (Object)calciteSchema);
        }
    }

    @Override
    protected void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.schema.getTableNames());
    }

    @Override
    protected void addImplicitFunctionsToBuilder(ImmutableList.Builder<Function> builder, String name, boolean caseSensitive) {
        Collection<Function> functions = this.schema.getFunctions(name);
        if (functions != null) {
            builder.addAll(functions);
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.schema.getFunctionNames());
    }

    @Override
    protected void addImplicitTypeNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.schema.getTypeNames());
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableSortedMap explicitTables = builder.build();
        for (String s : this.schema.getFunctionNames()) {
            if (explicitTables.containsKey((Object)s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected @Nullable CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        Collection<Function> functions = this.schema.getFunctions(tableName);
        if (functions != null) {
            for (Function function : functions) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<? extends Object>)ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    @Override
    protected CalciteSchema snapshot(@Nullable CalciteSchema parent, SchemaVersion version) {
        SimpleCalciteSchema snapshot = new SimpleCalciteSchema(parent, this.schema.snapshot(version), this.name, null, this.tableMap, this.latticeMap, this.typeMap, this.functionMap, this.functionNames, this.nullaryFunctionMap, this.getPath());
        for (CalciteSchema subSchema : this.subSchemaMap.map().values()) {
            CalciteSchema subSchemaSnapshot = subSchema.snapshot(snapshot, version);
            snapshot.subSchemaMap.put(subSchema.name, subSchemaSnapshot);
        }
        return snapshot;
    }

    @Override
    protected boolean isCacheEnabled() {
        return false;
    }
}

