/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.TolerantUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;

public class TolerantUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
UpdateRequestProcessorFactory.RunAlways {
    private static final String MAX_ERRORS_PARAM = "maxErrors";
    private int defaultMaxErrors = Integer.MAX_VALUE;
    private boolean informed = false;

    @Override
    public void init(NamedList args) {
        Object maxErrorsObj = args.get(MAX_ERRORS_PARAM);
        if (maxErrorsObj != null) {
            try {
                this.defaultMaxErrors = Integer.parseInt(maxErrorsObj.toString());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unnable to parse maxErrors parameter: " + maxErrorsObj, (Throwable)e);
            }
            if (this.defaultMaxErrors < -1) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Config option 'maxErrors' must either be non-negative, or -1 to indicate 'unlimiited': " + maxErrorsObj.toString());
            }
        }
    }

    @Override
    public void inform(SolrCore core) {
        this.informed = true;
        if (null == core.getLatestSchema().getUniqueKeyField()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getName() + " requires a schema that includes a uniqueKey field.");
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        assert (this.informed) : "inform(SolrCore) never called?";
        DistributedUpdateProcessor.DistribPhase distribPhase = DistributedUpdateProcessor.DistribPhase.parseParam(req.getParams().get("update.distrib"));
        if (DistributedUpdateProcessor.DistribPhase.FROMLEADER.equals((Object)distribPhase)) {
            return next;
        }
        DistributedUpdateProcessorFactory.addParamToDistributedRequestWhitelist(req, MAX_ERRORS_PARAM);
        int maxErrors = req.getParams().getInt(MAX_ERRORS_PARAM, this.defaultMaxErrors);
        if (maxErrors < -1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'maxErrors' must either be non-negative, or -1 to indicate 'unlimiited': " + maxErrors);
        }
        return new TolerantUpdateProcessor(req, rsp, next, maxErrors, distribPhase);
    }
}

