/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryValidationException;

public class AlreadyExistsException
extends QueryValidationException {
    private static final long serialVersionUID = 0L;
    private final String keyspace;
    private final String table;

    public AlreadyExistsException(String keyspace, String table) {
        super(AlreadyExistsException.makeMsg(keyspace, table));
        this.keyspace = keyspace;
        this.table = table;
    }

    private AlreadyExistsException(String msg, Throwable cause, String keyspace, String table) {
        super(msg, cause);
        this.keyspace = keyspace;
        this.table = table;
    }

    private static String makeMsg(String keyspace, String table) {
        if (table.isEmpty()) {
            return String.format("Keyspace %s already exists", keyspace);
        }
        return String.format("Table %s.%s already exists", keyspace, table);
    }

    public boolean wasTableCreation() {
        return !this.table.isEmpty();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table.isEmpty() ? null : this.table;
    }

    @Override
    public DriverException copy() {
        return new AlreadyExistsException(this.getMessage(), (Throwable)this, this.keyspace, this.table);
    }
}

