/*
 * SurgeScript
 * A scripting language for games
 * Copyright 2016-2021 Alexandre Martins <alemartf(at)gmail(dot)com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * util/version.h
 * SurgeScript version: available at compile time
 */

#ifndef _SURGESCRIPT_VERSION_H
#define _SURGESCRIPT_VERSION_H

/* Import SurgeScript version */
#define SURGESCRIPT_VERSION_SUP 0
#define SURGESCRIPT_VERSION_SUB 5
#define SURGESCRIPT_VERSION_WIP 5
/* #undef SURGESCRIPT_VERSION_FIX */

#if !defined(SURGESCRIPT_VERSION_FIX)
#define SURGESCRIPT_VERSION_FIX 0
#endif

/* Generate version string */
#define SURGESCRIPT_VERSION_STR "0.5.5"

/* Convert a version tuple into an integer */
#define SURGESCRIPT_VERSION_CODE(x, y, z, w) \
    (((x) << 24) | ((y) << 16) | ((z) << 8) | (w))

/* Compare a version tuple to the current version of SurgeScript */
#define SURGESCRIPT_VERSION_COMPARE(x, y, z, w) ( \
    SURGESCRIPT_VERSION_CODE( \
        SURGESCRIPT_VERSION_SUP, \
        SURGESCRIPT_VERSION_SUB, \
        SURGESCRIPT_VERSION_WIP, \
        SURGESCRIPT_VERSION_FIX \
    ) - \
    SURGESCRIPT_VERSION_CODE((x), (y), (z), (w)) \
)

/* Check if the current version of SurgeScript is x.y.z.w or newer */
#define SURGESCRIPT_VERSION_IS_AT_LEAST(x, y, z, w) \
    (SURGESCRIPT_VERSION_COMPARE((x), (y), (z), (w)) >= 0)

#endif
