/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.fife.io.UnicodeReader;
import org.fife.rtext.RText;
import org.fife.ui.OS;
import org.fife.ui.rtextarea.IconGroup;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IconGroupLoader
extends DefaultHandler {
    public static final String DEFAULT_ICON_GROUP_NAME = "Eclipse Icons";
    private RText owner;
    private Map<String, IconGroup> iconGroupMap;
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String LARGEICONSUBDIR = "largeIconSubDir";
    private static final String EXTENSION = "extension";
    private static final String JAR = "jar";

    private IconGroupLoader(RText owner) {
        this.owner = owner;
        this.iconGroupMap = new HashMap<String, IconGroup>(3);
    }

    private void addOfficeLnFsIconGroups() {
        String windows98Icons = "Windows 98 Icons";
        String office2003Icons = "Office 2003 Icons";
        IconGroup win98IconGroup = new IconGroup(windows98Icons, "org/fife/plaf/OfficeXP/");
        IconGroup office2003IconGroup = new IconGroup(office2003Icons, "org/fife/plaf/Office2003/");
        this.iconGroupMap.put(win98IconGroup.getName(), win98IconGroup);
        this.iconGroupMap.put(office2003IconGroup.getName(), office2003IconGroup);
    }

    private XMLReader createReader() {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            try {
                reader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException se) {
                this.owner.displayException(se);
            }
        }
        return reader;
    }

    private Map<String, IconGroup> doLoad(String iconGroupFile) {
        try {
            XMLReader xr = this.createReader();
            if (xr == null) {
                return this.iconGroupMap;
            }
            xr.setContentHandler(this);
            InputSource is = new InputSource(new UnicodeReader(new FileInputStream(iconGroupFile), "UTF-8"));
            is.setEncoding("UTF-8");
            xr.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.owner.displayException(e);
            return this.iconGroupMap;
        }
        if (this.owner.getOS() == OS.WINDOWS) {
            this.addOfficeLnFsIconGroups();
        }
        return this.iconGroupMap;
    }

    public static Map<String, IconGroup> loadIconGroups(RText rtext, String iconGroupFile) {
        IconGroupLoader loader = new IconGroupLoader(rtext);
        return loader.doLoad(iconGroupFile);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (GROUP.equals(qName)) {
            String name = attributes.getValue(NAME);
            String path = attributes.getValue(PATH);
            if (path == null) {
                path = "";
            }
            String largeIconSubDir = attributes.getValue(LARGEICONSUBDIR);
            String extension = attributes.getValue(EXTENSION);
            String jar = attributes.getValue(JAR);
            if (jar != null) {
                jar = this.owner.getInstallLocation() + '/' + jar;
            }
            IconGroup group = new IconGroup(name, path, largeIconSubDir, extension, jar);
            this.iconGroupMap.put(name, group);
        }
    }
}

