/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyPanel
extends JPanel {
    private final GridBagLayout _layout = new GridBagLayout();
    private boolean _singleColumn = true;
    private int _nbrComponents;
    private int _lastY;

    public PropertyPanel() {
        this.setLayout(this._layout);
    }

    public void setSingleColumn(boolean value) {
        this._singleColumn = value;
    }

    public void add(JLabel label, Component data) {
        this.add(label, data, null);
    }

    public void add(JLabel label, Component data, Component extra) {
        label.setLabelFor(data);
        this.pvtAdd(label, data, extra);
    }

    public void add(JLabel leftLabel, JLabel rightlabel) {
        this.pvtAdd(leftLabel, rightlabel, null);
    }

    public void add(Component left, Component right) {
        this.pvtAdd(left, right, null);
    }

    public void add(Component left, Component right, Component extra) {
        this.pvtAdd(left, right, extra);
    }

    private void pvtAdd(Component leftComp, Component rightComp, Component extra) {
        boolean isOdd = ++this._nbrComponents % 2 != 0;
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this._singleColumn || isOdd ? ++this._lastY : this._lastY;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.insets = new Insets(4, 4, 4, 4);
        cons.fill = 1;
        cons.gridx = this._singleColumn || isOdd ? 0 : 3;
        cons.weightx = 0.0;
        this._layout.setConstraints(leftComp, cons);
        this.add(leftComp);
        ++cons.gridx;
        cons.weightx = 1.0;
        if (extra != null) {
            Box box = Box.createHorizontalBox();
            box.add(rightComp);
            box.add(extra);
            this._layout.setConstraints(box, cons);
            this.add(box);
        } else {
            this._layout.setConstraints(rightComp, cons);
            this.add(rightComp);
        }
    }
}

