/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

class FormatSQLCommand
implements ICommand {
    private final ISession _session;
    private ISQLPanelAPI _panel;

    FormatSQLCommand(ISession session, ISQLPanelAPI panel) {
        this._session = session;
        this._panel = panel;
    }

    @Override
    public void execute() throws BaseException {
        int[] bounds = this._panel.getSQLEntryPanel().getBoundsOfSQLToBeExecuted();
        if (bounds[0] == bounds[1]) {
            return;
        }
        String textToReformat = this._panel.getSQLEntryPanel().getSQLToBeExecuted();
        if (null == textToReformat) {
            return;
        }
        CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", StringUtilities.getEolStr())};
        String statementSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
        CodeReformator cr = new CodeReformator(CodeReformatorConfigFactory.createConfig(this._session));
        String reformatedText = cr.reformat(textToReformat);
        this._panel.getSQLEntryPanel().setSelectionStart(bounds[0]);
        this._panel.getSQLEntryPanel().setSelectionEnd(bounds[1]);
        this._panel.getSQLEntryPanel().replaceSelection(reformatedText);
    }
}

