/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TitleFilePathHandlerListener;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TitleFilePathHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TitleFilePathHandler.class);
    private static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_FILE_NAME = "Squirrel.TitleFilePathHandler.showFileName";
    private static final String PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_PATH_NAME = "Squirrel.TitleFilePathHandler.showPathName";
    private File _sqlFile;
    private SquirrelResources _resources;
    private TitleFilePathHandlerListener _titleFilePathHandlerListener;
    private SmallTabButton _smallTabButton;
    private JPopupMenu _popUp;
    private JCheckBoxMenuItem _chkMnuShowFileName;
    private JCheckBoxMenuItem _chkMnuShowFilePath;

    public TitleFilePathHandler(SquirrelResources resources, TitleFilePathHandlerListener titleFilePathHandlerListener) {
        this._resources = resources;
        this._titleFilePathHandlerListener = titleFilePathHandlerListener;
        String msg = s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.tooltip");
        this._smallTabButton = new SmallTabButton(msg, this._resources.getIcon("smallFile"));
        this._smallTabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.showPopup();
            }
        });
        this._popUp = new JPopupMenu();
        JMenuItem mnuOpenFilePath = new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.openFilePath"));
        this._popUp.add(mnuOpenFilePath);
        mnuOpenFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.onOpenFilePath();
            }
        });
        JMenuItem mnuCopyFilePath = new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.copyFilePath"));
        this._popUp.add(mnuCopyFilePath);
        mnuCopyFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.onCopyFilePath();
            }
        });
        this._popUp.addSeparator();
        this._chkMnuShowFileName = new JCheckBoxMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showFileName"));
        this._popUp.add(this._chkMnuShowFileName);
        this._chkMnuShowFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.onChkMnuShowFileName();
            }
        });
        this._chkMnuShowFilePath = new JCheckBoxMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.showFilePath"));
        this._popUp.add(this._chkMnuShowFilePath);
        this._chkMnuShowFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.onChkMnuShowFilePath();
            }
        });
        JMenuItem mnuRememberCheckboxes = new JMenuItem(s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.rememberCheckBoxes"));
        this._popUp.add(mnuRememberCheckboxes);
        mnuRememberCheckboxes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TitleFilePathHandler.this.onRememberCheckboxes();
            }
        });
        this._chkMnuShowFileName.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_FILE_NAME, false));
        this._chkMnuShowFilePath.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_PATH_NAME, false));
    }

    private void onRememberCheckboxes() {
        Preferences.userRoot().putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_FILE_NAME, this._chkMnuShowFileName.isSelected());
        Preferences.userRoot().putBoolean(PREF_KEY_TITLE_FILE_PATH_HANDLER_SHOW_PATH_NAME, this._chkMnuShowFilePath.isSelected());
    }

    private void onChkMnuShowFilePath() {
        this._chkMnuShowFileName.setSelected(false);
        this._titleFilePathHandlerListener.refreshFileDisplay();
    }

    private void onChkMnuShowFileName() {
        this._chkMnuShowFilePath.setSelected(false);
        this._titleFilePathHandlerListener.refreshFileDisplay();
    }

    private void onCopyFilePath() {
        if (this.hasFile()) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(this._sqlFile.getAbsolutePath());
            clip.setContents(data, data);
        }
    }

    private void onOpenFilePath() {
        try {
            if (this.hasFile()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(this._sqlFile.getParentFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void showPopup() {
        this._popUp.show(this._smallTabButton, 0, 0);
    }

    public void setSqlFile(File sqlFile) {
        this._sqlFile = sqlFile;
        if (null == this._sqlFile) {
            this._smallTabButton.setIcon(this._resources.getIcon("smallFile"));
            this._smallTabButton.setToolTipText("");
        } else {
            this._smallTabButton.setToolTipText(this._sqlFile.getAbsolutePath());
        }
    }

    public boolean hasFile() {
        return null != this._sqlFile;
    }

    public String getSqlFile() {
        if (this._chkMnuShowFilePath.isSelected()) {
            return "  " + s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.pathDisplayPrefix", this._sqlFile.getAbsolutePath());
        }
        if (this._chkMnuShowFileName.isSelected()) {
            return "  " + s_stringMgr.getString("desktopcontainer.TitleFilePathHandler.fileDisplayPrefix", this._sqlFile.getName());
        }
        return "";
    }

    public SmallTabButton getFileMenuSmallButton() {
        return this._smallTabButton;
    }

    public void setUnsavedEdits(boolean unsavedEdits) {
        if (unsavedEdits) {
            this._smallTabButton.setIcon(this._resources.getIcon("smallFileChanged"));
        } else {
            this._smallTabButton.setIcon(this._resources.getIcon("smallFile"));
        }
    }
}

