/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.Application;
import net.sourceforge.squirrel_sql.client.DesktopTabbedPaneOutwardDndChanel;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.OutwardDndTabbedPaneChanel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPaneHolder;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.RemoveTabHandelResult;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;

public class MultipleWindowsHandler {
    private HashSet<DockTabDesktopPaneHolder> _dockTabDesktopPaneHolders = new HashSet();
    private DockTabDesktopPaneHolder _curSelectedDockTabDesktopPaneHolder;
    private DesktopTabbedPaneOutwardDndChanel _outwardDndTabbedPaneChanel;
    private Application _app;
    private DockTabDesktopPaneHolder _mainDockTabDesktopPaneHolder;

    public MultipleWindowsHandler(Application app) {
        this._app = app;
        this._outwardDndTabbedPaneChanel = new DesktopTabbedPaneOutwardDndChanel(this._app);
    }

    public void registerDesktop(DockTabDesktopPaneHolder dockTabDesktopPaneHolder) {
        this._dockTabDesktopPaneHolders.add(dockTabDesktopPaneHolder);
    }

    public void selectDesktop(DockTabDesktopPaneHolder dockTabDesktopPaneHolder) {
        if (dockTabDesktopPaneHolder == this._curSelectedDockTabDesktopPaneHolder) {
            return;
        }
        this._curSelectedDockTabDesktopPaneHolder.setSelected(false);
        this._curSelectedDockTabDesktopPaneHolder = dockTabDesktopPaneHolder;
        this._curSelectedDockTabDesktopPaneHolder.setSelected(true);
    }

    public void registerMainFrame(final DockTabDesktopPane mainDesktop) {
        this._mainDockTabDesktopPaneHolder = new DockTabDesktopPaneHolder(){

            @Override
            public void setSelected(boolean b) {
                MultipleWindowsHandler.this.onSelectMainDesktop(b, mainDesktop);
            }

            @Override
            public void tabDragedAndDroped() {
                MultipleWindowsHandler.this.onTabDragedAndDroped(mainDesktop);
            }

            @Override
            public void addTabWidgetAt(TabWidget widget, int tabIndex, ArrayList<SmallTabButton> externalButtons, boolean widgetMovedButNotCreated) {
                mainDesktop.addTabWidgetAt(widget, tabIndex, externalButtons, widgetMovedButNotCreated);
            }

            @Override
            public RemoveTabHandelResult removeTabHandel(int tabIndex) {
                return mainDesktop.removeTabHandel(tabIndex);
            }

            @Override
            public boolean isMyTabbedPane(JTabbedPane tabbedPane) {
                return mainDesktop.isMyTabbedPane(tabbedPane);
            }

            @Override
            public void addTabWidget(TabWidget widget, ArrayList<SmallTabButton> externalButtons, boolean widgetMovedButNotCreated) {
                mainDesktop.addTabWidgetAt(widget, mainDesktop.getTabCount(), externalButtons, widgetMovedButNotCreated);
            }
        };
        this._dockTabDesktopPaneHolders.add(this._mainDockTabDesktopPaneHolder);
        this._curSelectedDockTabDesktopPaneHolder = this._mainDockTabDesktopPaneHolder;
        this._app.getMainFrame().addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MultipleWindowsHandler.this.selectDesktop(MultipleWindowsHandler.this._mainDockTabDesktopPaneHolder);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }

    private void onTabDragedAndDroped(DockTabDesktopPane mainDesktop) {
        this.adjustSessionMenu(mainDesktop);
    }

    private void onSelectMainDesktop(boolean b, DockTabDesktopPane mainDesktop) {
        mainDesktop.setSelected(b);
        this.adjustSessionMenu(mainDesktop);
    }

    private void adjustSessionMenu(DockTabDesktopPane mainDesktop) {
        if (null == mainDesktop.getSelectedWidget()) {
            this._app.getWindowManager().setEnabledSessionMenu(false);
        } else {
            this._app.getWindowManager().setEnabledSessionMenu(true);
        }
    }

    public void unregisterDesktop(DockTabDesktopPaneHolder dockTabDesktopPaneHolder) {
        this._dockTabDesktopPaneHolders.remove(dockTabDesktopPaneHolder);
        this._outwardDndTabbedPaneChanel.removeListener(dockTabDesktopPaneHolder);
    }

    public OutwardDndTabbedPaneChanel getOutwardDndTabbedPaneChanel() {
        return this._outwardDndTabbedPaneChanel;
    }

    public DockTabDesktopPaneHolder getDockTabDesktopPaneOfTabbedPane(JTabbedPane tabbedPane) {
        for (DockTabDesktopPaneHolder dockTabDesktopPaneHolder : this._dockTabDesktopPaneHolders) {
            if (!dockTabDesktopPaneHolder.isMyTabbedPane(tabbedPane)) continue;
            return dockTabDesktopPaneHolder;
        }
        throw new IllegalArgumentException("Could not find DockTabDesktopPane for TabbedPane " + tabbedPane);
    }

    public DockTabDesktopPaneHolder getMainDockTabDesktopHolder() {
        return this._mainDockTabDesktopPaneHolder;
    }
}

