/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.repo.RelativeURLRepository;
import org.apache.ivy.plugins.repository.url.ChainedRepository;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Message;

public class MirroredURLResolver
extends RepositoryResolver {
    private URL mirrorListUrl;

    public MirroredURLResolver() {
        this.setRepository(new ChainedRepository());
    }

    public void setMirrorListUrl(URL uRL) {
        this.mirrorListUrl = uRL;
    }

    private void setupMirrors() {
        List list;
        File file = this.downloadMirrorList();
        try {
            list = this.readMirrorList(file);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("The mirror list could not be read from " + this.mirrorListUrl + " (" + iOException.getMessage() + ")");
        }
        ArrayList<RelativeURLRepository> arrayList = new ArrayList<RelativeURLRepository>();
        for (String string : list) {
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Message.warn("In the mirror list from " + this.mirrorListUrl + ", an incorrect url has been found and will then not be used: " + string);
            }
            if (uRL == null) continue;
            RelativeURLRepository relativeURLRepository = new RelativeURLRepository(uRL);
            arrayList.add(relativeURLRepository);
        }
        ((ChainedRepository)this.getRepository()).setRepositories(arrayList);
    }

    private File downloadMirrorList() {
        URLRepository uRLRepository = new URLRepository();
        if (this.getEventManager() != null) {
            uRLRepository.addTransferListener(this.getEventManager());
        }
        URLResource uRLResource = new URLResource(this.mirrorListUrl);
        CacheResourceOptions cacheResourceOptions = new CacheResourceOptions();
        ArtifactDownloadReport artifactDownloadReport = this.getRepositoryCacheManager().downloadRepositoryResource(uRLResource, "mirrorlist", "text", "txt", cacheResourceOptions, uRLRepository);
        return artifactDownloadReport.getLocalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List readMirrorList(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return arrayList;
    }

    @Override
    public String getTypeName() {
        return "mirroredurl";
    }

    @Override
    public void validate() {
        super.validate();
        this.setupMirrors();
    }
}

