/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Runtime {
    private static final Runtime current = new Runtime();
    private final String[] libpath;
    private Thread exitSequence;
    private Set shutdownHooks;

    public static Runtime getRuntime() {
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit(int status) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(status);
        }
        if (this.runShutdownHooks()) {
            this.halt(status);
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.shutdownHooks != null) {
                this.shutdownHooks.remove(Thread.currentThread());
                this.exitSequence.interrupt();
                status = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (status != 0) {
                this.halt(status);
            }
            while (true) {
                try {
                    this.exitSequence.join();
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    boolean runShutdownHooks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 15->89)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addShutdownHook(Thread hook) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        if (hook.isAlive() || hook.getThreadGroup() == null) {
            throw new IllegalArgumentException("The hook thread " + hook + " must not have been already run or started");
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException("The Virtual Machine is exiting. It is not possible anymore to add any hooks");
            }
            if (this.shutdownHooks == null) {
                VMRuntime.enableShutdownHooks();
                this.shutdownHooks = new HashSet();
            }
            if (!this.shutdownHooks.add(hook)) {
                throw new IllegalArgumentException(hook.toString() + " had already been inserted");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeShutdownHook(Thread hook) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException();
            }
            if (this.shutdownHooks != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.shutdownHooks.remove(hook);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public void halt(int status) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(status);
        }
        VMRuntime.exit(status);
    }

    public static void runFinalizersOnExit(boolean finalizeOnExit) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExit(0);
        }
        VMRuntime.runFinalizersOnExit(finalizeOnExit);
    }

    public Process exec(String cmdline) throws IOException {
        return this.exec(cmdline, null, null);
    }

    public Process exec(String cmdline, String[] env) throws IOException {
        return this.exec(cmdline, env, null);
    }

    public Process exec(String cmdline, String[] env, File dir) throws IOException {
        StringTokenizer t = new StringTokenizer(cmdline);
        String[] cmd = new String[t.countTokens()];
        int i = 0;
        while (i < cmd.length) {
            cmd[i] = t.nextToken();
            ++i;
        }
        return this.exec(cmd, env, dir);
    }

    public Process exec(String[] cmd) throws IOException {
        return this.exec(cmd, null, null);
    }

    public Process exec(String[] cmd, String[] env) throws IOException {
        return this.exec(cmd, env, null);
    }

    public Process exec(String[] cmd, String[] env, File dir) throws IOException {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkExec(cmd[0]);
        }
        return VMRuntime.exec(cmd, env, dir);
    }

    public int availableProcessors() {
        return VMRuntime.availableProcessors();
    }

    public long freeMemory() {
        return VMRuntime.freeMemory();
    }

    public long totalMemory() {
        return VMRuntime.totalMemory();
    }

    public long maxMemory() {
        return VMRuntime.maxMemory();
    }

    public void gc() {
        VMRuntime.gc();
    }

    public void runFinalization() {
        VMRuntime.runFinalization();
    }

    public void traceInstructions(boolean on) {
        VMRuntime.traceInstructions(on);
    }

    public void traceMethodCalls(boolean on) {
        VMRuntime.traceMethodCalls(on);
    }

    public void load(String filename) {
        this.load(filename, VMStackWalker.getCallingClassLoader());
    }

    void load(String filename, ClassLoader loader) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkLink(filename);
        }
        if (Runtime.loadLib(filename, loader) == 0) {
            throw new UnsatisfiedLinkError("Could not load library " + filename);
        }
    }

    private static final int loadLib(String filename, ClassLoader loader) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkRead(filename);
        }
        return VMRuntime.nativeLoad(filename, loader == null ? null : loader.vmData);
    }

    public void loadLibrary(String libname) {
        this.loadLibrary(libname, VMStackWalker.getCallingClassLoader());
    }

    void loadLibrary(String libname, ClassLoader loader) {
        String filename;
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkLink(libname);
        }
        if (loader != null && (filename = loader.findLibrary(libname)) != null) {
            if (Runtime.loadLib(filename, loader) != 0) {
                return;
            }
        } else {
            filename = VMRuntime.mapLibraryName(libname);
            int i = 0;
            while (i < this.libpath.length) {
                if (Runtime.loadLib(this.libpath[i] + filename, loader) != 0) {
                    return;
                }
                ++i;
            }
        }
        throw new UnsatisfiedLinkError("Native library `" + libname + "' not found (as file `" + filename + "') in gnu.classpath.boot.library.path and java.library.path");
    }

    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }

    private Runtime() {
        String prefix;
        if (current != null) {
            throw new InternalError("Attempt to recreate Runtime");
        }
        String bootPath = SystemProperties.getProperty("gnu.classpath.boot.library.path", "");
        String path = SystemProperties.getProperty("java.library.path", ".");
        String pathSep = SystemProperties.getProperty("path.separator", ":");
        String fileSep = SystemProperties.getProperty("file.separator", "/");
        StringTokenizer t1 = new StringTokenizer(bootPath, pathSep);
        StringTokenizer t2 = new StringTokenizer(path, pathSep);
        this.libpath = new String[t1.countTokens() + t2.countTokens()];
        int i = 0;
        while (t1.hasMoreTokens()) {
            prefix = t1.nextToken();
            if (!prefix.endsWith(fileSep)) {
                prefix = prefix + fileSep;
            }
            this.libpath[i] = prefix;
            ++i;
        }
        while (t2.hasMoreTokens()) {
            prefix = t2.nextToken();
            if (!prefix.endsWith(fileSep)) {
                prefix = prefix + fileSep;
            }
            this.libpath[i] = prefix;
            ++i;
        }
    }
}

