/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.sql.SqlStatement;
import org.jetbrains.dekaf.sql.TextFragment;
import org.jetbrains.dekaf.util.StringOperator;

public class SqlQuery<S>
extends SqlStatement {
    @NotNull
    private final ResultLayout<S> myLayout;
    private transient String myDisplayName;

    public SqlQuery(@NotNull TextFragment sourceFragment, @NotNull ResultLayout<S> layout) {
        super(sourceFragment);
        this.myLayout = layout;
    }

    public SqlQuery(@NotNull String sourceText, @NotNull ResultLayout<S> layout) {
        super(sourceText);
        this.myLayout = layout;
    }

    public SqlQuery(int row, @NotNull String sourceText, @Nullable String name, @NotNull String description, @NotNull ResultLayout<S> layout, String displayName) {
        super(row, sourceText, name, description);
        this.myLayout = layout;
        this.myDisplayName = displayName;
    }

    protected void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        if (this.myDisplayName == null) {
            this.prepareDisplayName();
        }
        return this.myDisplayName;
    }

    private synchronized void prepareDisplayName() {
        if (this.myDisplayName != null) {
            return;
        }
        int nl = this.mySourceText.indexOf(10);
        String str1 = nl > 0 ? this.mySourceText.substring(0, nl) : this.mySourceText;
        this.myDisplayName = str1 = str1.trim();
    }

    @Override
    @NotNull
    public SqlQuery<S> rewrite(@NotNull StringOperator operator) {
        String transformedSourceText = (String)operator.apply(this.mySourceText);
        return new SqlQuery<S>(this.myRow, transformedSourceText, this.myName, this.myDescription, this.myLayout, this.myDescription);
    }

    @NotNull
    public ResultLayout<S> getLayout() {
        return this.myLayout;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }
}

