/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class JavaScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    public JavaScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JavaScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JavaScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    @Override
    public void visitComment(PsiComment comment) {
        this.checkFlowCommentWithinLanguageVersion(comment);
        super.visitComment(comment);
    }

    private void checkFlowCommentWithinLanguageVersion(PsiComment comment) {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)comment);
        if (optionHolder == null || optionHolder.isFlow || !optionHolder.isJavaScript()) {
            return;
        }
        int flagStart = CharArrayUtil.indexOf((CharSequence)comment.getNode().getChars(), (CharSequence)"@flow", (int)0);
        if (flagStart >= 0) {
            String message = JSBundle.message((String)"js.flowjs.flag.without.language.version", (Object[])new Object[0]);
            LocalQuickFix[] fixes = new LocalQuickFix[]{new ChangeLanguageLevelFix(JSLanguageLevel.FLOW)};
            TextRange range = TextRange.from((int)flagStart, (int)"@flow".length()).shiftRight(comment.getTextRange().getStartOffset());
            this.myProblemReporter.registerProblem((PsiElement)comment, range, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, fixes, IntentionAction.EMPTY_ARRAY);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/validation/JavaScriptAnnotatingVisitor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

