/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6KeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    public ES6KeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(DialectOptionHolder.ECMA_6, true));
    }

    public ES6KeywordHighlighterVisitor(AnnotationHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    @Override
    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.OF_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitJSAttributeList(JSAttributeList element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.ASYNC_KEYWORD);
        super.visitJSAttributeList(element);
    }

    public void visitJSPrefixExpression(JSPrefixExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSPrefixExpression(element);
    }

    public void visitES6Decorator(ES6Decorator decorator) {
        PsiElement element;
        JSExpression expression;
        ASTNode at = decorator.getNode().findChildByType(JSTokenTypes.AT);
        if (at != null) {
            this.highlightDecorator(at.getPsi());
        }
        if ((expression = decorator.getExpression()) instanceof JSCallExpression) {
            expression = ((JSCallExpression)expression).getMethodExpression();
        }
        if (expression instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).getReferenceNameElement()) != null) {
            this.highlightDecorator(element);
        }
        super.visitES6Decorator(decorator);
    }

    private void highlightDecorator(@NotNull PsiElement node) {
        if (node == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        TextAttributesKey key = this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR);
        JSSemanticHighlightingUtil.justLineMarker(node, key, "decorator", this.myHolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/ES6KeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightDecorator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

