/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.linter.jscs.config.JscsConfigHelper;
import com.intellij.lang.javascript.linter.jscs.config.JscsExcludeFileInConfigFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JscsCreateConfigAndExcludeFix
implements HighPriorityAction,
IntentionAction {
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myRelativePath;

    public JscsCreateConfigAndExcludeFix(@NotNull String name, @NotNull String path) {
        if (name == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(1);
        }
        this.myFileName = name;
        this.myRelativePath = path;
    }

    @NotNull
    public String getText() {
        String string = "Create config.jscs.json and exclude " + this.myFileName + " from JSCS analysis there.";
        if (string == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create config.jscs.json and exclude file(s) from JSCS analysis there." == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(3);
        }
        return "Create config.jscs.json and exclude file(s) from JSCS analysis there.";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        VirtualFile config2;
        if (project == null) {
            JscsCreateConfigAndExcludeFix.$$$reportNull$$$0(5);
        }
        if ((config2 = JscsConfigHelper.createConfigBasedOnPreset(project)) != null) {
            new JscsExcludeFileInConfigFix(config2, this.myFileName, this.myRelativePath).invoke(project, editor, file2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jscs/config/JscsCreateConfigAndExcludeFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

