/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueBase;
import org.jetbrains.plugins.github.api.data.GithubIssueComment;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.issue.GithubIssuesLoadingHelper;
import org.jetbrains.plugins.github.tasks.GithubComment;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;

@Tag(value="GitHub")
public class GithubRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(GithubRepository.class);
    private Pattern myPattern = Pattern.compile("($^)");
    @NotNull
    private String myRepoAuthor = "";
    @NotNull
    private String myRepoName = "";
    @NotNull
    private String myUser = "";
    @NotNull
    private String myToken = "";
    private boolean myAssignedIssuesOnly = false;

    public GithubRepository() {
    }

    public GithubRepository(GithubRepository other) {
        super((BaseRepositoryImpl)other);
        this.setRepoName(other.myRepoName);
        this.setRepoAuthor(other.myRepoAuthor);
        this.setToken(other.myToken);
        this.setAssignedIssuesOnly(other.myAssignedIssuesOnly);
    }

    public GithubRepository(GithubRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUrl("https://github.com");
    }

    @NotNull
    public TaskRepository.CancellableConnection createCancellableConnection() {
        TaskRepository.CancellableConnection cancellableConnection = new TaskRepository.CancellableConnection(){
            private final GithubApiRequestExecutor myExecutor;
            private final ProgressIndicator myIndicator;
            {
                this.myExecutor = GithubRepository.this.getExecutor();
                this.myIndicator = new EmptyProgressIndicator();
            }

            protected void doTest() throws Exception {
                try {
                    this.myExecutor.execute(this.myIndicator, GithubApiRequests.Repos.get(GithubRepository.this.getServer(), GithubRepository.this.getRepoAuthor(), GithubRepository.this.getRepoName()));
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }

            public void cancel() {
                this.myIndicator.cancel();
            }
        };
        if (cancellableConnection == null) {
            GithubRepository.$$$reportNull$$$0(0);
        }
        return cancellableConnection;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) && !StringUtil.isEmptyOrSpaces((String)this.getRepoName()) && !StringUtil.isEmptyOrSpaces((String)this.getToken());
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getRepoAuthor()) ? "/" + this.getRepoAuthor() : "") + (!StringUtil.isEmpty((String)this.getRepoName()) ? "/" + this.getRepoName() : "");
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        try {
            return this.getIssues(query, offset + limit, withClosed);
        }
        catch (GithubRateLimitExceededException e) {
            return Task.EMPTY_ARRAY;
        }
        catch (GithubAuthenticationException | GithubStatusCodeException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubJsonException e) {
            throw new Exception("Bad response format", e);
        }
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed, @NotNull ProgressIndicator cancelled) throws Exception {
        if (cancelled == null) {
            GithubRepository.$$$reportNull$$$0(1);
        }
        return this.getIssues(query, offset, limit, withClosed);
    }

    @NotNull
    private Task[] getIssues(@Nullable String query, int max, boolean withClosed) throws Exception {
        GithubApiRequestExecutor executor = this.getExecutor();
        ProgressIndicator indicator = GithubRepository.getProgressIndicator();
        GithubServerPath server = this.getServer();
        String assigned = null;
        if (this.myAssignedIssuesOnly) {
            if (StringUtil.isEmptyOrSpaces((String)this.myUser)) {
                this.myUser = executor.execute(indicator, GithubApiRequests.CurrentUser.get(server)).getLogin();
            }
            assigned = this.myUser;
        }
        List<GithubIssueBase> issues = StringUtil.isEmptyOrSpaces((String)query) ? GithubIssuesLoadingHelper.load(executor, indicator, server, this.getRepoAuthor(), this.getRepoName(), withClosed, max, assigned) : GithubIssuesLoadingHelper.search(executor, indicator, server, this.getRepoAuthor(), this.getRepoName(), withClosed, assigned, query);
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (GithubIssueBase issue : issues) {
            List<GithubIssueComment> comments = GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.Repos.Issues.Comments.pages(issue.getCommentsUrl()));
            tasks.add(this.createTask(issue, comments));
        }
        Task[] taskArray = tasks.toArray(Task.EMPTY_ARRAY);
        if (taskArray == null) {
            GithubRepository.$$$reportNull$$$0(2);
        }
        return taskArray;
    }

    @NotNull
    private Task createTask(final @NotNull GithubIssueBase issue, final @NotNull List<GithubIssueComment> comments) {
        if (issue == null) {
            GithubRepository.$$$reportNull$$$0(3);
        }
        if (comments == null) {
            GithubRepository.$$$reportNull$$$0(4);
        }
        Task task = new Task(){
            @NotNull
            private final String myRepoName;
            @NotNull
            private final Comment[] myComments;
            {
                this.myRepoName = GithubRepository.this.getRepoName();
                this.myComments = (Comment[])ContainerUtil.map2Array((Collection)comments, Comment.class, comment -> new GithubComment(comment.getCreatedAt(), comment.getUser().getLogin(), comment.getBodyHtml(), comment.getUser().getAvatarUrl(), comment.getUser().getHtmlUrl()));
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return issue.getHtmlUrl();
            }

            @NotNull
            public String getId() {
                String string = this.myRepoName + "-" + issue.getNumber();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = issue.getTitle();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getDescription() {
                return issue.getBody();
            }

            @NotNull
            public Comment[] getComments() {
                if (this.myComments == null) {
                    2.$$$reportNull$$$0(2);
                }
                return this.myComments;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.Vcs.Vendors.Github;
                if (icon == null) {
                    2.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.BUG;
                if (taskType == null) {
                    2.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            public Date getUpdated() {
                return issue.getUpdatedAt();
            }

            public Date getCreated() {
                return issue.getCreatedAt();
            }

            public boolean isClosed() {
                return issue.getState() == GithubIssueState.closed;
            }

            public TaskRepository getRepository() {
                return GithubRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/github/tasks/GithubRepository$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (task == null) {
            GithubRepository.$$$reportNull$$$0(5);
        }
        return task;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher;
        if (taskName == null) {
            GithubRepository.$$$reportNull$$$0(6);
        }
        return (matcher = this.myPattern.matcher(taskName)).find() ? matcher.group(1) : null;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        ProgressIndicator indicator;
        int index;
        if (id == null) {
            GithubRepository.$$$reportNull$$$0(7);
        }
        if ((index = id.lastIndexOf("-")) < 0) {
            return null;
        }
        String numericId = id.substring(index + 1);
        GithubApiRequestExecutor executor = this.getExecutor();
        GithubIssue issue = executor.execute(indicator = GithubRepository.getProgressIndicator(), GithubApiRequests.Repos.Issues.get(this.getServer(), this.getRepoAuthor(), this.getRepoName(), numericId));
        if (issue == null) {
            return null;
        }
        List<GithubIssueComment> comments = GithubApiPagesLoader.loadAll(executor, indicator, GithubApiRequests.Repos.Issues.Comments.pages(issue.getCommentsUrl()));
        return this.createTask(issue, comments);
    }

    public void setTaskState(@NotNull Task task, @NotNull TaskState state2) throws Exception {
        boolean isOpen;
        if (task == null) {
            GithubRepository.$$$reportNull$$$0(8);
        }
        if (state2 == null) {
            GithubRepository.$$$reportNull$$$0(9);
        }
        switch (state2) {
            case OPEN: {
                isOpen = true;
                break;
            }
            case RESOLVED: {
                isOpen = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state2);
            }
        }
        GithubApiRequestExecutor executor = this.getExecutor();
        GithubServerPath server = this.getServer();
        String repoAuthor = this.getRepoAuthor();
        String repoName = this.getRepoName();
        ProgressIndicator indicator = GithubRepository.getProgressIndicator();
        executor.execute(indicator, GithubApiRequests.Repos.Issues.updateState(server, repoAuthor, repoName, task.getNumber(), isOpen));
    }

    @NotNull
    public BaseRepository clone() {
        GithubRepository githubRepository = new GithubRepository(this);
        if (githubRepository == null) {
            GithubRepository.$$$reportNull$$$0(10);
        }
        return githubRepository;
    }

    @NotNull
    public String getRepoName() {
        String string = this.myRepoName;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setRepoName(@NotNull String repoName) {
        if (repoName == null) {
            GithubRepository.$$$reportNull$$$0(12);
        }
        this.myRepoName = repoName;
        this.myPattern = Pattern.compile("(" + StringUtil.escapeToRegexp((String)repoName) + "\\-\\d+)");
    }

    @NotNull
    public String getRepoAuthor() {
        String string = this.myRepoAuthor;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setRepoAuthor(@NotNull String repoAuthor) {
        if (repoAuthor == null) {
            GithubRepository.$$$reportNull$$$0(14);
        }
        this.myRepoAuthor = repoAuthor;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setUser(@NotNull String user) {
        if (user == null) {
            GithubRepository.$$$reportNull$$$0(16);
        }
        this.myUser = user;
    }

    @Transient
    @NotNull
    public String getToken() {
        String string = this.myToken;
        if (string == null) {
            GithubRepository.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void setToken(@NotNull String token2) {
        if (token2 == null) {
            GithubRepository.$$$reportNull$$$0(18);
        }
        this.myToken = token2;
        this.setUser("");
    }

    public boolean isAssignedIssuesOnly() {
        return this.myAssignedIssuesOnly;
    }

    public void setAssignedIssuesOnly(boolean value) {
        this.myAssignedIssuesOnly = value;
    }

    @Tag(value="token")
    public String getEncodedToken() {
        return PasswordUtil.encodePassword((String)this.getToken());
    }

    public void setEncodedToken(String password) {
        try {
            this.setToken(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException e) {
            LOG.warn("Can't decode token", (Throwable)e);
        }
    }

    @NotNull
    private GithubApiRequestExecutor getExecutor() {
        GithubApiRequestExecutor.WithTokenAuth withTokenAuth = GithubApiRequestExecutor.Factory.getInstance().create(this.getToken(), this.myUseProxy);
        if (withTokenAuth == null) {
            GithubRepository.$$$reportNull$$$0(19);
        }
        return withTokenAuth;
    }

    @NotNull
    private static ProgressIndicator getProgressIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            GithubRepository.$$$reportNull$$$0(20);
        }
        return progressIndicator;
    }

    @NotNull
    private GithubServerPath getServer() {
        GithubServerPath githubServerPath = GithubServerPath.from(this.getUrl());
        if (githubServerPath == null) {
            GithubRepository.$$$reportNull$$$0(21);
        }
        return githubServerPath;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GithubRepository)) {
            return false;
        }
        GithubRepository that = (GithubRepository)((Object)o);
        if (!Comparing.equal((String)this.getRepoAuthor(), (String)that.getRepoAuthor())) {
            return false;
        }
        if (!Comparing.equal((String)this.getRepoName(), (String)that.getRepoName())) {
            return false;
        }
        if (!Comparing.equal((String)this.getToken(), (String)that.getToken())) {
            return false;
        }
        return Comparing.equal((Object)this.isAssignedIssuesOnly(), (Object)that.isAssignedIssuesOnly());
    }

    public int hashCode() {
        return StringUtil.stringHashCode((CharSequence)this.getRepoName()) + 31 * StringUtil.stringHashCode((CharSequence)this.getRepoAuthor());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/tasks/GithubRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoAuthor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCancellableConnection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/tasks/GithubRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoAuthor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUser";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToken";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressIndicator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIssues";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRepoName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setRepoAuthor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setUser";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setToken";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

