/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.templates;

import b.h.la;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.hash.HashSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.templates.TemplateIntegration;
import org.jetbrains.plugins.ruby.templates.a;

public final class TemplateIntegrationUtils {
    @NonNls
    public static final ExtensionPointName<TemplateIntegration> EP_NAME;
    private static final long a;

    private TemplateIntegrationUtils() {
    }

    public static TemplateIntegrationUtils getInstance() {
        return SingletonHolder.a;
    }

    public TokenSet computeOuterElements() {
        ArrayList<? extends IElementType> arrayList = new ArrayList<IElementType>();
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            arrayList.addAll(templateIntegration.getOuterElements());
        }
        return TokenSet.create((IElementType[])arrayList.toArray(IElementType.EMPTY_ARRAY));
    }

    public TokenSet computeContinuationElements() {
        ArrayList<? extends IElementType> arrayList = new ArrayList<IElementType>();
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            arrayList.addAll(templateIntegration.getContinuationElements());
        }
        return TokenSet.create((IElementType[])arrayList.toArray(IElementType.EMPTY_ARRAY));
    }

    public TokenSet getEndTokens() {
        ArrayList<? extends IElementType> arrayList = new ArrayList<IElementType>();
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            arrayList.addAll(templateIntegration.getEndElements());
        }
        return TokenSet.create((IElementType[])arrayList.toArray(IElementType.EMPTY_ARRAY));
    }

    public boolean isTemplateFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!templateIntegration.isTemplateFile(file)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemplateFile(@Nullable FileType type) {
        if (type == null) {
            return false;
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!templateIntegration.getFileType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean mustCloseRubyBlock(@NotNull PsiElement context) {
        PsiFile psiFile;
        Language language;
        if (context == null) {
            TemplateIntegrationUtils.a(0);
        }
        Language language2 = language = (psiFile = context.getContainingFile()) != null ? psiFile.getLanguage() : null;
        if (language != null) {
            for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
                if (!templateIntegration.getLanguage().equals(language)) continue;
                return templateIntegration.mustCloseRubyBlock();
            }
        }
        return true;
    }

    @Nullable
    public PsiElement addRubyStatement(@NotNull FileViewProvider provider, @NotNull RCompoundStatement parent, @NotNull PsiElement elementToAdd, @Nullable PsiElement anchor, boolean before) {
        if (provider == null) {
            TemplateIntegrationUtils.a(1);
        }
        if (parent == null) {
            TemplateIntegrationUtils.a(2);
        }
        if (elementToAdd == null) {
            TemplateIntegrationUtils.a(3);
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!templateIntegration.canModifyPsiInsert(provider)) continue;
            return templateIntegration.addRubyStatement(provider, parent, elementToAdd, anchor, before);
        }
        return null;
    }

    @Nullable
    public FileType getFileType(@NotNull TemplateLang lang) {
        if (lang == null) {
            TemplateIntegrationUtils.a(4);
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            FileType fileType = templateIntegration.getFileType(lang);
            if (fileType == null) continue;
            return fileType;
        }
        return null;
    }

    public boolean shouldNotInspectHash(@Nullable RAssocList list2) {
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!templateIntegration.shouldNotInspectHash(list2)) continue;
            return true;
        }
        return false;
    }

    public FileType[] allKnownFileTypes(FileType ... defaultTypes) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(Arrays.asList(defaultTypes));
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            hashSet.add(templateIntegration.getFileType());
        }
        return hashSet.toArray(FileType.EMPTY_ARRAY);
    }

    @Nullable
    public TemplateLang getTemplateLanguageByExtension(@Nullable String extension) {
        if (extension == null) {
            return null;
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!extension.equals(templateIntegration.getFileType().getDefaultExtension())) continue;
            return templateIntegration.getTemplateLanguage();
        }
        return null;
    }

    @Nullable
    public TemplateLang getTemplateLanguageByName(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!fileName.endsWith(templateIntegration.getFileType().getDefaultExtension())) continue;
            return templateIntegration.getTemplateLanguage();
        }
        return null;
    }

    @Nullable
    public TemplateLang getTemplateLanguage(@Nullable Language language) {
        if (language == null) {
            return null;
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!language.equals(templateIntegration.getLanguage())) continue;
            return templateIntegration.getTemplateLanguage();
        }
        return null;
    }

    @Nullable
    public String getTextForI18n(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TemplateIntegrationUtils.a(5);
        }
        if (file == null) {
            TemplateIntegrationUtils.a(6);
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            String string = templateIntegration.getTextForI18n(editor, file);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public void replaceTextWithI18n(@NotNull Editor editor, @NotNull PsiFile file, @NotNull RExpression expression) {
        if (editor == null) {
            TemplateIntegrationUtils.a(7);
        }
        if (file == null) {
            TemplateIntegrationUtils.a(8);
        }
        if (expression == null) {
            TemplateIntegrationUtils.a(9);
        }
        for (TemplateIntegration templateIntegration : EP_NAME.getExtensionList()) {
            if (!templateIntegration.replaceTextWithI18n(editor, file, expression)) continue;
            return;
        }
    }

    /* synthetic */ TemplateIntegrationUtils(a x0) {
        this();
    }

    static {
        a = la.a(-7544419110093113009L, 6759618090992362464L, MethodHandles.lookup().lookupClass()).a(181326759122264L);
        long l2 = a ^ 0x109DDCCA0B98L;
        EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.templates.integration");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x6517C4806AEFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/templates/TemplateIntegrationUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mustCloseRubyBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addRubyStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextForI18n";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceTextWithI18n";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SingletonHolder {
        private static final TemplateIntegrationUtils a = new TemplateIntegrationUtils(null);

        private SingletonHolder() {
        }
    }

    public static final class TemplateLang
    extends Enum<TemplateLang> {
        public static final /* enum */ TemplateLang ERB;
        public static final /* enum */ TemplateLang HAML;
        public static final /* enum */ TemplateLang SLIM;
        private static final /* synthetic */ TemplateLang[] a;

        public static TemplateLang[] values() {
            return (TemplateLang[])a.clone();
        }

        public static TemplateLang valueOf(String name) {
            return Enum.valueOf(TemplateLang.class, name);
        }

        static {
            long l2 = la.a(1647671957895109048L, -2921322587460025105L, MethodHandles.lookup().lookupClass()).a(139104067984863L) ^ 0x6E48E72F5F00L;
            ERB = new TemplateLang();
            HAML = new TemplateLang();
            SLIM = new TemplateLang();
            a = new TemplateLang[]{ERB, HAML, SLIM};
        }
    }
}

