/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import b.h.la;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.lang.RubyElementNameAndDescriptionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.FieldType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RubyHelpUtil {
    private static final Logger b;
    @NonNls
    static final String ELEMENT = "ELEMENT";
    @NonNls
    static final String COMMA = ",";
    private static final String c = "[undefined]";
    private static final String a;
    private static final long d;

    private RubyHelpUtil() {
    }

    @Nullable
    public static String getSimpleInfo(@Nullable RPsiElement targetElement, boolean forNavigateInfo) {
        Symbol symbol;
        long l2 = d ^ 0x1E7A1F9FE1BDL;
        if (targetElement == null || targetElement instanceof PsiFile) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Symbol symbol2 = symbol = targetElement instanceof RContainer ? SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)targetElement)) : null;
        if (symbol != null) {
            RubyHelpUtil.a(symbol, stringBuilder, !forNavigateInfo);
        } else {
            String string = RubyHelpUtil.a(targetElement);
            if (string != null) {
                stringBuilder.append(string).append(forNavigateInfo ? " " : "&nbsp;");
            }
        }
        RubyHelpUtil.a((PsiElement)targetElement, symbol, stringBuilder, !forNavigateInfo);
        RubyHelpUtil.a(targetElement, symbol, stringBuilder, !forNavigateInfo);
        if (!forNavigateInfo) {
            RubyHelpUtil.a(null, targetElement, stringBuilder, null);
        }
        if (symbol != null) {
            RubyHelpUtil.a(symbol, stringBuilder, !forNavigateInfo, (PsiElement)targetElement);
        }
        if (symbol != null && !forNavigateInfo) {
            RubyHelpUtil.a(symbol, targetElement, stringBuilder);
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @Nullable
    public static String getHelpByElement(@Nullable PsiElement elementAtCursor, @Nullable RPsiElement rPsiElementAtCursor, @NotNull RPsiElement targetElement) {
        String string;
        long l2 = d ^ 0x1650FB71CE90L;
        if (targetElement == null) {
            RubyHelpUtil.a(0);
        }
        if (targetElement instanceof RFile) {
            b.info("No documentation: target is file");
            return null;
        }
        if (rPsiElementAtCursor != null) {
            string = RubyHelpUtil.a(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (string != null) {
                return string;
            }
        } else {
            b.info("no original RPsiElement");
        }
        if (targetElement instanceof RContainer) {
            string = (RContainer)targetElement;
            Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)string);
            if (symbol != null) {
                return RubyHelpUtil.a(symbol, rPsiElementAtCursor, targetElement);
            }
            b.info("No documentation: no symbol for container");
            return null;
        }
        if (RubyHelpUtil.b(targetElement) || targetElement instanceof RConstant || targetElement instanceof RField || targetElement instanceof RGlobalVariable || targetElement instanceof RAliasStatement || targetElement instanceof RCall || targetElement instanceof RBlockCall) {
            string = RubyHelpUtil.a(elementAtCursor, rPsiElementAtCursor, targetElement);
            if (string != null) {
                return string;
            }
            return RubyHelpUtil.c(targetElement);
        }
        b.info("No documentation: unknown target element type " + targetElement.getClass().getName());
        return null;
    }

    @Nullable
    private static String a(@NotNull RPsiElement rPsiElement) {
        RConstant rConstant;
        long l2 = d ^ 0x5E6499687B70L;
        if (rPsiElement == null) {
            RubyHelpUtil.a(1);
        }
        if (rPsiElement instanceof RIdentifier) {
            RIdentifier rIdentifier = (RIdentifier)rPsiElement;
            if (rIdentifier.isParameter()) {
                return RBundle.message((String)"parameter");
            }
            if (rIdentifier.isLocalVariable()) {
                return RBundle.message((String)"local.variable");
            }
            return null;
        }
        if (rPsiElement instanceof RConstant && RubyPsiUtil.isDeclaration((PsiElement)(rConstant = (RConstant)rPsiElement))) {
            return RBundle.message((String)"constant");
        }
        if (rPsiElement instanceof RField) {
            rConstant = (RField)rPsiElement;
            return rConstant.getFieldType() == FieldType.CLASS_VARIABLE ? RBundle.message((String)"class.variable") : RBundle.message((String)"instance.variable");
        }
        if (rPsiElement instanceof RGlobalVariable && RubyPsiUtil.isDeclaration((PsiElement)(rConstant = (RGlobalVariable)rPsiElement))) {
            return RBundle.message((String)"global.variable");
        }
        if (rPsiElement instanceof RMethod) {
            return RBundle.message((String)"method");
        }
        if (rPsiElement instanceof RClass) {
            return RBundle.message((String)"class");
        }
        if (rPsiElement instanceof RModule) {
            return RBundle.message((String)"module");
        }
        return null;
    }

    private static void a(@NotNull StringBuilder stringBuilder, @NotNull RType rType) {
        long l2 = d ^ 0x70AADE95501FL;
        if (stringBuilder == null) {
            RubyHelpUtil.a(2);
        }
        if (rType == null) {
            RubyHelpUtil.a(3);
        }
        stringBuilder.append("<br>").append("<br>");
        RubyDocumentationMarkupUtil.appendBold(stringBuilder, RBundle.message((String)"ruby.doc.inferred.type"));
        String string = RubyHelpUtil.a(rType);
        stringBuilder.append(" '").append(string).append("'");
    }

    @Nullable
    private static String a(RType rType) {
        if (rType instanceof RSymbolType) {
            Symbol symbol = ((RSymbolType)rType).getSymbol();
            return RubyHelpUtil.createRefText(symbol, false);
        }
        return rType.getPresentableName();
    }

    static String createRefText(Symbol symbol, boolean shortName) {
        String string;
        long l2 = d ^ 0x588BCDDD0BAFL;
        StringBuilder stringBuilder = new StringBuilder();
        PsiElement psiElement = symbol.getPsiElement();
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        String string2 = virtualFile != null ? virtualFile.getPath() + "::" + psiElement.getTextRange().getStartOffset() : null;
        String string3 = string = shortName ? symbol.getName() : RContainerPresentationUtil.getPresentableSymbolName(symbol, psiElement);
        if (string2 != null) {
            DocumentationManager.createHyperlink((StringBuilder)stringBuilder, (String)string2, (String)string, (boolean)true);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static PsiElement getElementByLink(String link, PsiManager psiManager) {
        long l2 = d ^ 0x2AACB80DB969L;
        if (link.contains("::")) {
            String[] stringArray = link.split("::", 2);
            try {
                PsiElement psiElement;
                PsiFile psiFile;
                int n2 = Integer.parseInt(stringArray[1]);
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)stringArray[0]));
                if (virtualFile != null && (psiFile = psiManager.findFile(virtualFile)) != null && (psiElement = psiFile.findElementAt(n2)) != null) {
                    return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNamedElement.class);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static RType a(RMethod rMethod) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rMethod);
        if (symbol == null) {
            return null;
        }
        RType rType = RubyTypeProvider.createTypeBySymbolFromProviders(symbol, Context.INSTANCE);
        if (rType != null) {
            return rType;
        }
        rType = rMethod.getReturnTypeFromComment();
        if (rType != null) {
            return rType;
        }
        return TypeInferenceContext.getInstance(rMethod.getProject()).inferControlFlowBasedReturnType(rMethod);
    }

    @NotNull
    private static String a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyHelpUtil.a(4);
        }
        if (psiElement instanceof RContainer) {
            String string = ((RContainer)psiElement).getName();
            if (psiElement instanceof RMethod) {
                String string2 = ((RMethod)psiElement).getPresentableName(true);
                if (string2 == null) {
                    RubyHelpUtil.a(5);
                }
                return string2;
            }
            String string3 = string;
            if (string3 == null) {
                RubyHelpUtil.a(6);
            }
            return string3;
        }
        for (RubyElementNameAndDescriptionProvider rubyElementNameAndDescriptionProvider : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String string = rubyElementNameAndDescriptionProvider.getPresentableName(psiElement);
            if (string == null) continue;
            String string4 = string;
            if (string4 == null) {
                RubyHelpUtil.a(7);
            }
            return string4;
        }
        String string = psiElement.getText();
        if (string == null) {
            RubyHelpUtil.a(8);
        }
        return string;
    }

    private static void a(@Nullable String string, @Nullable String string2, StringBuilder stringBuilder, boolean bl2) {
        String string3;
        long l2 = d ^ 0x7707D948FA82L;
        String string4 = string3 = !StringUtil.isEmpty((String)string) ? string : c;
        if (bl2) {
            RubyDocumentationMarkupUtil.appendBoldCode(stringBuilder, string3);
        } else {
            stringBuilder.append(string3);
        }
        String string5 = !StringUtil.isEmpty((String)string2) ? string2 : c;
        stringBuilder.append("(").append(RBundle.message((String)"ruby.doc.original")).append(": ");
        if (bl2) {
            RubyDocumentationMarkupUtil.appendBoldCode(stringBuilder, string5);
        } else {
            stringBuilder.append(string5);
        }
        stringBuilder.append(')');
    }

    private static void a(StringBuilder stringBuilder, PsiElement psiElement, @Nullable Symbol symbol) {
        PsiElement psiElement2;
        RubyMotionUtil rubyMotionUtil;
        long l2 = d ^ 0xC0AFA65A377L;
        String string = RubyCommentsUtil.getPsiHelp(psiElement);
        if (string == null && symbol != null && symbol.getType() == Type.ALIAS && (rubyMotionUtil = SymbolUtil.getMethodSymbolByAlias(symbol)) != null && (psiElement2 = rubyMotionUtil.getPsiElement()) != null) {
            string = RubyCommentsUtil.getPsiHelp(psiElement2);
        }
        if (string != null) {
            string = RubyDocumentationMarkupUtil.processCodeDocumentation(symbol, string);
        }
        rubyMotionUtil = RubyMotionUtil.getInstance();
        if (string == null && rubyMotionUtil.isMotionSymbol(symbol)) {
            string = rubyMotionUtil.getMotionDoc(psiElement, symbol);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("<br>").append("<hr>");
        }
        if (string != null) {
            stringBuilder.append(rubyMotionUtil.isMotionSymbol(symbol) ? "" : RubyHelpUtil.a());
            stringBuilder.append(string);
        } else {
            stringBuilder.append(RBundle.message((String)"ruby.doc.not.found"));
        }
    }

    private static String a() {
        long l2 = d ^ 0x79C0A3C09661L;
        return "<h2>" + RBundle.message((String)"ruby.doc.documentation") + ":</h2>";
    }

    private static void a(@NotNull StringBuilder stringBuilder, @NotNull Collection<? extends PsiElement> collection) {
        long l2 = d ^ 0x2EB7AF6EDFA4L;
        if (stringBuilder == null) {
            RubyHelpUtil.a(9);
        }
        if (collection == null) {
            RubyHelpUtil.a(10);
        }
        boolean bl2 = false;
        int n2 = 0;
        for (PsiElement psiElement : collection) {
            String string = null;
            String string2 = null;
            if (psiElement instanceof RContainer) {
                string = RContainerPresentationUtil.getLocation((RPsiElement)((RContainer)psiElement));
                string2 = ELEMENT + n2;
            }
            if (string != null && string2 != null) {
                if (bl2) {
                    stringBuilder.append(COMMA);
                    String string3 = "&nbsp;";
                    stringBuilder.append("&nbsp;").append("&nbsp;");
                }
                bl2 = true;
                stringBuilder.append(string);
            }
            ++n2;
        }
    }

    @Nullable
    private static String a(PsiElement psiElement, RPsiElement rPsiElement, RPsiElement rPsiElement2) {
        long l2 = d ^ 0x258E45206016L;
        PsiReference psiReference = RubyHelpUtil.b(psiElement);
        if (psiReference instanceof RPsiPolyVariantReference) {
            ResolveResult[] resolveResultArray = ((RPsiPolyVariantReference)psiReference).multiResolve(false);
            if (resolveResultArray.length == 0) {
                return null;
            }
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            PsiElement psiElement2 = null;
            String string = null;
            for (ResolveResult object : resolveResultArray) {
                PsiElement psiElement3;
                if (object instanceof SymbolResolveResult && (psiElement3 = ((SymbolResolveResult)object).getSymbol()) != null) {
                    if (string == null) {
                        string = RubyHelpUtil.a((Symbol)psiElement3, rPsiElement, rPsiElement2);
                        psiElement2 = psiElement3;
                    } else if (psiElement2 != psiElement3) {
                        string = a;
                    }
                }
                if ((psiElement3 = object.getElement()) == null) continue;
                arrayList.add(psiElement3);
            }
            if (string != null && string != a) {
                return string;
            }
            if (arrayList.size() == 1) {
                return RubyHelpUtil.c((RPsiElement)arrayList.get(0));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<h2>").append(RBundle.message((String)"ruby.doc.several.variants")).append(":</h2>");
            for (PsiElement psiElement4 : arrayList) {
                String string2 = RubyHelpUtil.c((RPsiElement)psiElement4);
                if (string2 != null) {
                    String string3 = string2.replaceAll("<hr>|<hr/>", "<br>").replaceAll("(<br>|<br/>)+", "<br>").replaceAll(RubyHelpUtil.a(), "");
                    stringBuilder.append("<hr>").append(string3);
                    continue;
                }
                stringBuilder.append("<hr>").append(RubyHelpUtil.getSimpleInfo((RPsiElement)psiElement4, false));
            }
            return stringBuilder.toString();
        }
        b.info("no help from symbol: no reference found");
        return null;
    }

    @Nullable
    private static PsiReference b(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiReference psiReference = psiElement.getReference();
        if (psiReference != null) {
            return psiReference;
        }
        return psiElement.getContainingFile().findReferenceAt(psiElement.getTextRange().getStartOffset());
    }

    @Nullable
    private static String c(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RubyHelpUtil.a(11);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = RubyHelpUtil.getSimpleInfo(rPsiElement, false);
        if (string != null) {
            stringBuilder.append(string);
        }
        RubyHelpUtil.a(stringBuilder, (PsiElement)rPsiElement, null);
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @Nullable
    private static String a(@NotNull Symbol symbol, @Nullable RPsiElement rPsiElement, @NotNull RPsiElement rPsiElement2) {
        if (symbol == null) {
            RubyHelpUtil.a(12);
        }
        if (rPsiElement2 == null) {
            RubyHelpUtil.a(13);
        }
        StringBuilder stringBuilder = new StringBuilder();
        RubyHelpUtil.a(symbol, stringBuilder, true);
        RubyHelpUtil.a((PsiElement)rPsiElement2, symbol, stringBuilder, true);
        RubyHelpUtil.a(rPsiElement2, symbol, stringBuilder, true);
        RubyHelpUtil.a(rPsiElement, rPsiElement2, stringBuilder, symbol);
        RubyHelpUtil.a(symbol, stringBuilder, true, (PsiElement)rPsiElement);
        RubyHelpUtil.a(symbol, rPsiElement2, stringBuilder);
        RubyHelpUtil.a(stringBuilder, (PsiElement)rPsiElement2, symbol);
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private static void a(@NotNull PsiElement psiElement, @Nullable Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        Object object;
        if (psiElement == null) {
            RubyHelpUtil.a(14);
        }
        if (symbol != null && symbol.getType() == Type.ALIAS) {
            if (psiElement instanceof RCall) {
                object = ((RCall)psiElement).getArguments();
                if (object.size() == 2) {
                    RPsiElement rPsiElement = (RPsiElement)object.get(0);
                    RPsiElement rPsiElement2 = (RPsiElement)object.get(1);
                    RubyHelpUtil.a(rPsiElement != null ? RubyPsiUtil.getElementText((PsiElement)rPsiElement) : null, rPsiElement2 != null ? RubyPsiUtil.getElementText((PsiElement)rPsiElement2) : null, stringBuilder, bl2);
                    return;
                }
            } else if (psiElement instanceof RAliasStatement) {
                RAliasStatement rAliasStatement = (RAliasStatement)psiElement;
                RubyHelpUtil.a(rAliasStatement.getName(), rAliasStatement.getOldName(), stringBuilder, bl2);
                return;
            }
        }
        object = RubyHelpUtil.a(psiElement);
        if (bl2) {
            RubyDocumentationMarkupUtil.appendBoldCode(stringBuilder, (String)object);
        } else {
            stringBuilder.append((String)object);
        }
    }

    private static void a(RPsiElement rPsiElement, @Nullable Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        String string;
        long l2 = d ^ 0x369016E284D2L;
        String string2 = string = bl2 ? "&nbsp;" : " ";
        if (rPsiElement instanceof RContainer || symbol != null && symbol.getType() == Type.ALIAS) {
            Object object;
            if (rPsiElement instanceof RMethod) {
                object = ((RMethod)rPsiElement).getVisibility().getPresentableName();
                stringBuilder.insert(0, string).insert(0, (String)object);
            } else if (symbol != null && symbol.getType() == Type.ALIAS && (object = SymbolUtil.getMethodSymbolByAlias(symbol)) != null && object instanceof RMethodSymbol) {
                Object object2 = ((RMethodSymbol)object).getVisibility().getPresentableName();
                stringBuilder.insert(0, string).insert(0, (String)object2);
            }
            stringBuilder.append(" ");
            stringBuilder.append(RBundle.message((String)"in")).append(string);
            object = RContainerPresentationUtil.getLocation(rPsiElement);
            if (bl2) {
                RubyDocumentationMarkupUtil.appendCode(stringBuilder, (String)object);
            } else {
                stringBuilder.append((String)object);
            }
        }
        for (Object object2 : RubyElementNameAndDescriptionProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            object2.appendVisibilityAndLocation((PsiElement)rPsiElement, stringBuilder, bl2);
        }
    }

    private static void a(Symbol symbol, RPsiElement rPsiElement, StringBuilder stringBuilder) {
        long l2 = d ^ 0x72D849405B8DL;
        if (Types.MODULE_OR_CLASS.contains(symbol.getType())) {
            List<Object> list2 = Collections.emptyList();
            if (rPsiElement instanceof RContainer) {
                list2 = RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)rPsiElement, false, (PsiElement)rPsiElement);
            }
            if (!list2.isEmpty()) {
                String string = RBundle.message((String)"partial");
                stringBuilder.append("<br>").append("<br>");
                RubyDocumentationMarkupUtil.appendBold(stringBuilder, string);
                stringBuilder.append("&nbsp;").append(RBundle.message((String)"in")).append(':');
                stringBuilder.append("<br>");
                RubyHelpUtil.a(stringBuilder, list2);
            }
        }
    }

    private static void a(@NotNull Symbol symbol, StringBuilder stringBuilder, boolean bl2, @Nullable PsiElement psiElement) {
        long l2 = d ^ 0x5601EEB5CD55L;
        if (symbol == null) {
            RubyHelpUtil.a(15);
        }
        if (symbol.getType() == Type.CLASS) {
            Symbol symbol2;
            Symbol symbol3 = symbol2 = symbol instanceof ClassModuleSymbol ? ((ClassModuleSymbol)symbol).getSuperClassSymbol(psiElement) : RubyMotionUtil.getInstance().getMotionSuperclass(symbol, psiElement);
            if (symbol2 != null) {
                String string = "Superclass";
                if (bl2) {
                    stringBuilder.append("<br>").append("<br>");
                    RubyDocumentationMarkupUtil.appendBold(stringBuilder, "Superclass");
                    stringBuilder.append(": ");
                } else {
                    stringBuilder.append("\n").append("Superclass").append(": ");
                }
                String string2 = bl2 ? RubyHelpUtil.createRefText(symbol2, false) : RContainerPresentationUtil.getPresentableSymbolName(symbol2, psiElement);
                String string3 = bl2 ? "&nbsp;" : " ";
                stringBuilder.append(string3).append(string3);
                stringBuilder.append(string2);
            }
        }
    }

    private static void a(@Nullable RPsiElement rPsiElement, RPsiElement rPsiElement2, StringBuilder stringBuilder, @Nullable Symbol symbol) {
        RType rType = null;
        if (RubyHelpUtil.b(rPsiElement)) {
            rType = RTypeUtil.getExpressionType((PsiElement)rPsiElement);
        }
        if (rType == null) {
            if (rPsiElement2 instanceof RMethod) {
                rType = RubyHelpUtil.a((RMethod)rPsiElement2);
            }
            if (rType == null && rPsiElement == null && RubyHelpUtil.b(rPsiElement2)) {
                rType = RTypeUtil.getExpressionType((PsiElement)rPsiElement2);
            }
        }
        if (rType == null && symbol instanceof TypedSymbol) {
            Context context = rPsiElement != null ? Context.getContext((PsiElement)rPsiElement) : null;
            context = context == null && rPsiElement2 != null ? Context.getContext((PsiElement)rPsiElement2) : context;
            RType rType2 = rType = context != null ? ((TypedSymbol)symbol).getType(context) : null;
        }
        if (RTypeUtil.isNotEmpty(rType)) {
            RubyHelpUtil.a(stringBuilder, rType);
        }
    }

    private static void a(Symbol symbol, StringBuilder stringBuilder, boolean bl2) {
        long l2 = d ^ 0x3CF9BDBDF61BL;
        String string = bl2 ? "&nbsp;" : " ";
        Type type = symbol.getType();
        String string2 = type.getPresentableName();
        if (string2 != null) {
            stringBuilder.append(string2).append(string);
        }
    }

    private static boolean b(@Nullable RPsiElement rPsiElement) {
        return rPsiElement instanceof RIdentifier || rPsiElement instanceof RInstanceVariable || rPsiElement instanceof RClassVariable || rPsiElement instanceof RConstant;
    }

    static {
        d = la.a(-7557960595474788621L, 6985121538585815754L, MethodHandles.lookup().lookupClass()).a(268582716279964L);
        b = Logger.getInstance(RubyHelpUtil.class);
        a = new String(new char[]{'\u0000'});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x496955C17CB6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSymbol";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyHelpUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHelpByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementKindInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendElementTypeFullInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionWithoutSymbol";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHelpForSymbol";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendPresentableName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendSuperClassInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

