/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import b.h.la;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger h;
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY;
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project i;
    private final RunConfigurationBase e;
    private boolean j = false;
    private String b;
    private CoverageRunner c;
    private boolean d = true;
    private boolean f = true;
    private boolean a = false;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite g;
    private static final long p;

    public CoverageEnabledConfiguration(RunConfigurationBase configuration) {
        this.e = configuration;
        this.i = configuration.getProject();
    }

    public RunConfigurationBase getConfiguration() {
        return this.e;
    }

    public boolean isCoverageEnabled() {
        return this.j;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.j = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.f;
    }

    public void setSampling(boolean sampling) {
        this.f = sampling;
    }

    public String getRunnerId() {
        return this.b;
    }

    @Nullable
    public CoverageRunner getCoverageRunner() {
        return this.c;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.c = coverageRunner;
        this.b = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public boolean isTrackPerTestCoverage() {
        return this.d;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.d = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.a;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.a = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.g;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.g = currentCoverageSuite;
    }

    public String getName() {
        return this.e.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(this.e)) continue;
            return coverageEngine.canHavePerTestCoverage(this.e);
        }
        return false;
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(0);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) != null) {
            return true;
        }
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        long l2 = p ^ 0x2E953F26EDE0L;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(1);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) == null) {
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
                coverageEnabledConfiguration = coverageEngine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            h.assertTrue(coverageEnabledConfiguration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)coverageEnabledConfiguration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        if (coverageEnabledConfiguration2 == null) {
            CoverageEnabledConfiguration.a(2);
        }
        return coverageEnabledConfiguration2;
    }

    @Nullable
    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = p ^ 0x2FEF4E46FB48L;
        this.j = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String string = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.d = string == null || Boolean.valueOf(string) != false;
        this.f = Boolean.parseBoolean(element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME, "true"));
        String string2 = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.a = string2 != null && Boolean.valueOf(string2) != false;
        String string3 = element.getAttributeValue(COVERAGE_RUNNER);
        if (string3 != null) {
            this.b = string3;
            this.c = null;
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.b)) continue;
                this.c = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = p ^ 0x1A2756350D5DL;
        if (this.j) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (!this.d) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (!this.f) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.a) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.c != null) {
            element.setAttribute(COVERAGE_RUNNER, this.c.getId());
        } else if (this.b != null) {
            element.setAttribute(COVERAGE_RUNNER, this.b);
        }
    }

    @Nullable
    @NonNls
    protected String createCoverageFile() {
        long l2 = p ^ 0x1948DBB71790L;
        if (this.c == null) {
            return null;
        }
        String string = PathManager.getSystemPath() + File.separator + "coverage";
        String string2 = string + File.separator + FileUtil.sanitizeFileName((String)this.i.getName()) + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.e.getName()) + "." + this.c.getDataFileExtension();
        new File(string).mkdirs();
        return string2;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    static {
        p = la.a(206241468476801011L, -8008973664924824455L, MethodHandles.lookup().lookupClass()).a(4815168995913L);
        long l2 = p ^ 0x7EF401C8F4B0L;
        h = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
        COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x5E756F27B4EDL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

