/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.CharTable;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.psi.SlimElementTypes;
import org.jetbrains.plugins.slim.psi.impl.SlimClassOrIdImpl;
import org.jetbrains.plugins.slim.psi.impl.SlimElementDescriptor;

public final class SlimTagImpl
extends XmlTagImpl
implements HtmlTag {
    public SlimTagImpl() {
        super(SlimElementTypes.SLIM_TAG);
    }

    @NotNull
    public String getName() {
        String name = super.getName();
        String string = !StringUtil.isEmpty((String)name) ? name : "div";
        if (string == null) {
            SlimTagImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String toString() {
        return "SlimTag:" + this.getName();
    }

    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            CharSequence name;
            ASTNode attrNameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            CharSequence charSequence = attrNameElement instanceof SlimClassOrIdImpl ? charTableByTree.intern((CharSequence)attribute.getLocalName()) : (name = attrNameElement != null ? attrNameElement.getChars() : null);
            if (name == null || (!caseSensitive || !name.equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)name, (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor() {
        return new SlimElementDescriptor(super.getDescriptor(), true, false);
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        if (name.equals("class")) {
            XmlAttribute[] attributes = this.getAttributes();
            StringBuilder attributeValue = new StringBuilder();
            for (XmlAttribute attribute : attributes) {
                if (!attribute.getName().equals("class")) continue;
                attributeValue.append(attribute.getValue()).append(' ');
            }
            attributesValueMap.put(name, attributeValue.toString().trim());
        } else {
            super.cacheOneAttributeValue(name, value, attributesValueMap);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/slim/psi/impl/SlimTagImpl", "getName"));
    }
}

