/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.RangeMarkerImpl");
    @NotNull
    private final Object myDocumentOrFile;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    RangeMarkerImpl(@NotNull DocumentEx document, int start2, int end, boolean register) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(0);
        }
        this(ObjectUtils.notNull((Object)FileDocumentManager.getInstance().getFile((Document)document), (Object)document), document.getTextLength(), start2, end, register, false, false);
    }

    RangeMarkerImpl(@NotNull VirtualFile virtualFile, int start2, int end, boolean register) {
        if (virtualFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(1);
        }
        this(virtualFile, Integer.MAX_VALUE, start2, end, register, false, false);
    }

    private RangeMarkerImpl(@NotNull Object documentOrFile, int documentTextLength, int start2, int end, boolean register, boolean greedyToLeft, boolean greedyToRight) {
        if (documentOrFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(2);
        }
        if (start2 < 0) {
            throw new IllegalArgumentException("Wrong start: " + start2 + "; end=" + end);
        }
        if (end > documentTextLength) {
            throw new IllegalArgumentException("Wrong end: " + end + "; document length=" + documentTextLength + "; start=" + start2);
        }
        if (start2 > end) {
            throw new IllegalArgumentException("start > end: start=" + start2 + "; end=" + end);
        }
        this.myDocumentOrFile = documentOrFile;
        this.myId = counter.next();
        if (register) {
            this.registerInTree(start2, end, greedyToLeft, greedyToRight, 0);
        }
    }

    protected void registerInTree(int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.getDocument().registerRangeMarker(this, start2, end, greedyToLeft, greedyToRight, layer);
    }

    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        boolean b = this.getDocument().removeRangeMarker(this);
        tree.checkMax(true);
        return b;
    }

    @Override
    public long getId() {
        return this.myId;
    }

    public void dispose() {
        this.unregisterInTree();
    }

    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    void invalidate(@NotNull Object reason) {
        if (reason == null) {
            RangeMarkerImpl.$$$reportNull$$$0(3);
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.processAliveKeys(markerEx -> {
                if (reason == null) {
                    RangeMarkerImpl.$$$reportNull$$$0(11);
                }
                this.myNode.getTree().beforeRemove(markerEx, reason);
                return true;
            });
        }
    }

    @NotNull
    public final DocumentEx getDocument() {
        DocumentEx document;
        Object file2 = this.myDocumentOrFile;
        DocumentEx documentEx = document = file2 instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getDocument((VirtualFile)file2) : (DocumentEx)file2;
        if (document == null) {
            LOG.error("document is null; isValid=" + this.isValid() + "; file=" + file2);
        }
        DocumentEx documentEx2 = document;
        if (documentEx2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(4);
        }
        return documentEx2;
    }

    public int getLayer() {
        return 0;
    }

    public void setGreedyToLeft(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToLeft()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), greedy, this.isGreedyToRight(), this.isStickingToRight(), this.getLayer());
    }

    public void setGreedyToRight(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), greedy, this.isStickingToRight(), this.getLayer());
    }

    public void setStickingToRight(boolean value) {
        if (!this.isValid() || value == this.isStickingToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), this.isGreedyToRight(), value, this.getLayer());
    }

    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isStickingToRight();
    }

    @Override
    public final void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(5);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = this.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && (this.intervalStart() > this.intervalEnd() || this.intervalStart() < 0 || this.intervalEnd() > docLength)) {
            LOG.error("Update failed. Event = " + e + ". old doc length=" + docLength + "; real doc length = " + this.getDocument().getTextLength() + "; " + this.getClass() + ". After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        if (!this.isValid()) {
            return;
        }
        TextRange newRange = RangeMarkerImpl.applyChange(e, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(newRange.getStartOffset());
        this.setIntervalEnd(newRange.getEndOffset());
    }

    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
    }

    @Nullable
    static TextRange applyChange(@NotNull DocumentEvent e, int intervalStart, int intervalEnd, boolean isGreedyToLeft, boolean isGreedyToRight, boolean isStickingToRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(7);
        }
        if (intervalStart == intervalEnd) {
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight, isStickingToRight);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (intervalEnd < offset) {
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return new ProperTextRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return new ProperTextRange(offset + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd >= offset && intervalEnd <= offset + oldLength && intervalStart < offset) {
            return new UnfairTextRange(intervalStart, offset);
        }
        return null;
    }

    @Nullable
    private static TextRange processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return null;
        }
        if (offset == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return new UnfairTextRange(intervalStart, intervalStart + e.getNewLength());
            }
            if (stickyRight) {
                return new UnfairTextRange(intervalStart + e.getNewLength(), intervalStart + e.getNewLength());
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            return new UnfairTextRange(intervalStart + e.getNewLength() - oldLength, intervalStart + e.getNewLength() - oldLength);
        }
        return new UnfairTextRange(intervalStart, intervalStart);
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    int setIntervalStart(int start2) {
        if (start2 < 0) {
            LOG.error("Negative start: " + start2);
        }
        return this.myNode.setIntervalStart(start2);
    }

    int setIntervalEnd(int end) {
        if (end < 0) {
            LOG.error("Negative end: " + end);
        }
        return this.myNode.setIntervalEnd(end);
    }

    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null || !node.isValid()) {
            return false;
        }
        Object file2 = this.myDocumentOrFile;
        return file2 instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file2);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(9);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            return true;
        }
        if (!file2.isValid() || file2.isDirectory() || RangeMarkerImpl.isBinaryWithoutDecompiler(file2)) {
            return false;
        }
        return !file2.getFileType().isBinary() || !FileUtilRt.isTooLarge((long)file2.getLength());
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(10);
        }
        return (fileType = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType) == null;
    }

    public boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }

    public RangeMarker findRangeMarkerAfter() {
        return this.myNode.getTree().findRangeMarkerAfter(this);
    }

    public RangeMarker findRangeMarkerBefore() {
        return this.myNode.getTree().findRangeMarkerBefore(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invalidate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

