/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OpenPartialDiffAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ui.OpenPartialDiffAction");
    private final int myLeftIndex;
    private final int myRightIndex;

    OpenPartialDiffAction(int leftIndex, int rightIndex, Icon icon) {
        super("", null, icon);
        this.myLeftIndex = leftIndex;
        this.myRightIndex = rightIndex;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenPartialDiffAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        Project project = OpenPartialDiffAction.projectFromDataContext(dataContext);
        Editor leftEditor = mergePanel.getEditor(this.myLeftIndex);
        Editor rightEditor = mergePanel.getEditor(this.myRightIndex);
        FileType type = mergePanel.getContentType();
        SimpleDiffRequest diffData = new SimpleDiffRequest(project, this.composeName());
        diffData.setContents((DiffContent)new DocumentContent(project, leftEditor.getDocument(), type), (DiffContent)new DocumentContent(project, rightEditor.getDocument(), type));
        diffData.setContentTitles(mergePanel.getVersionTitle(this.myLeftIndex), mergePanel.getVersionTitle(this.myRightIndex));
        LOG.assertTrue(DiffManagerImpl.INTERNAL_DIFF.canShow((DiffRequest)diffData));
        DiffManagerImpl.INTERNAL_DIFF.show((DiffRequest)diffData);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenPartialDiffAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        Project project = OpenPartialDiffAction.projectFromDataContext(dataContext);
        Presentation presentation = e.getPresentation();
        if (mergePanel == null || project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        Editor leftEditor = mergePanel.getEditor(this.myLeftIndex);
        Editor rightEditor = mergePanel.getEditor(this.myRightIndex);
        if (leftEditor == null || rightEditor == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(this.composeName());
        presentation.setEnabled(true);
    }

    private String composeName() {
        if (this.myLeftIndex == 0 && this.myRightIndex == 1) {
            return ActionsBundle.actionText((String)"Diff.ComparePartial.Base.Left");
        }
        if (this.myLeftIndex == 1 && this.myRightIndex == 2) {
            return ActionsBundle.actionText((String)"Diff.ComparePartial.Base.Right");
        }
        return ActionsBundle.actionText((String)"Diff.ComparePartial.Left.Right");
    }

    @Nullable
    private static Project projectFromDataContext(DataContext dataContext) {
        return (Project)CommonDataKeys.PROJECT.getData(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/ui/OpenPartialDiffAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

