/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ProfilingUtil;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class YourKitProfilerHandler
implements Profiler {
    private static YourKitProfilerHandler instance;
    private final ProfilersController myProfilersController = ProfilersController.getInstance();

    private YourKitProfilerHandler() {
    }

    public static synchronized YourKitProfilerHandler getInstance() {
        if (instance == null) {
            instance = new YourKitProfilerHandler();
        }
        return instance;
    }

    @Override
    public void startProfiling(@NotNull String activityName, @NotNull List<String> options) {
        if (activityName == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (activityName == null) {
                YourKitProfilerHandler.$$$reportNull$$$0(7);
            }
            if (!ProfilingUtil.hasValidController()) {
                try {
                    YourKitProfilerHandler.enableProfilerAgent();
                    Waiter.checkCondition(() -> ProfilingUtil.hasValidController()).await();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ProfilingUtil.startCPUProfiling();
            Timer.instance.start(activityName);
            this.myProfilersController.setCurrentProfiler(this);
        });
    }

    @Override
    @NotNull
    public String stopProfiling(@NotNull List<String> options) {
        if (options == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(2);
        }
        this.myProfilersController.setCurrentProfiler(this);
        Timer timer = Timer.instance;
        if (timer.isStarted()) {
            timer.stop();
            timer.reportToTeamCity();
        }
        this.myProfilersController.setReportsPath(ProfilingUtil.captureCPUSnapshot());
        String string = this.myProfilersController.getReportsPath() != null ? this.myProfilersController.getReportsPath() : "";
        if (string == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public File compressResults(@NotNull String pathToResult, @NotNull String archiveName) throws IOException {
        if (pathToResult == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(4);
        }
        if (archiveName == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(5);
        }
        return ProfilingUtil.compressSnapshot((String)pathToResult, (String)archiveName);
    }

    @Contract(pure=true)
    @NotNull
    private static String getAgentLibraryName() {
        String agent = "yjpagent";
        if (SystemInfo.isLinux) {
            agent = agent + "-linux";
        }
        if (SystemInfo.is64Bit && !SystemInfo.isMac) {
            agent = agent + "64";
        }
        String string = agent;
        if (string == null) {
            YourKitProfilerHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void enableProfilerAgent() throws Exception {
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            throw new Exception("Profiling agent is disabled in internal mode and can't be enabled dynamically.");
        }
        String agentOptions = "disablej2ee,disablealloc,onlylocal";
        String snapshotPath = System.getProperty("snapshots.path");
        if (snapshotPath != null) {
            agentOptions = agentOptions + ",dir=" + snapshotPath;
        }
        String agent = YourKitProfilerHandler.getAgentLibraryName();
        VirtualMachine virtualMachine = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
        if (SystemInfo.isLinux) {
            virtualMachine.loadAgentPath(PathManager.getBinPath() + "/lib" + agent + ".so", agentOptions);
        } else {
            virtualMachine.loadAgentLibrary(agent, agentOptions);
        }
        ProfilingUtil.reinitialize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/YourKitProfilerHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/YourKitProfilerHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stopProfiling";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopProfiling";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compressResults";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startProfiling$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

