/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.LineTokenizer;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;

public class MultiLineTooltipUI
extends MetalToolTipUI {
    private final List myLines = new ArrayList();

    @Override
    public void paint(Graphics g, JComponent c) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        Dimension size = c.getSize();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c.getForeground());
        int idx = 0;
        for (String line : this.myLines) {
            g.drawString(line, 3, metrics.getHeight() * (idx + 1));
            ++idx;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String[] lines;
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        int maxWidth = 0;
        this.myLines.clear();
        for (String line : lines = LineTokenizer.tokenize((char[])tipText.toCharArray(), (boolean)false)) {
            this.myLines.add(line);
            int width = SwingUtilities.computeStringWidth(metrics, line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int height = metrics.getHeight() * (lines.length < 1 ? 1 : lines.length);
        return new Dimension(maxWidth + 6, height + 4);
    }
}

