/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.jetbrains.php.phing.PhingActionIdUtils;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBundle;
import icons.PhingIcons;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PhingKeymapExtension
implements KeymapExtension {
    private static final Logger LOG = Logger.getInstance(PhingKeymapExtension.class);

    public KeymapGroup createGroup(Condition<AnAction> filtered, Project project) {
        if (project != null) {
            PhingActionIdUtils.updateRegisteredActions(project);
        }
        HashMap buildFileToGroup = new HashMap();
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(PhingBundle.message("phing.targets", new Object[0]), PhingIcons.ClosedPhingKeymap);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds(PhingActionIdUtils.getActionIdPrefix(project));
        Arrays.sort(ids);
        if (project != null) {
            ApplicationManager.getApplication().runReadAction(() -> PhingKeymapExtension.lambda$createGroup$0((String[])ids, filtered, actionManager, project, buildFileToGroup, result));
        }
        return result;
    }

    private static /* synthetic */ void lambda$createGroup$0(String[] ids, Condition filtered, ActionManagerEx actionManager, Project project, Map buildFileToGroup, KeymapGroup result) {
        for (String id : ids) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
            PhingBuildFile buildFile = PhingActionIdUtils.findBuildFileByActionId(id, project);
            if (buildFile != null) {
                KeymapGroup subGroup = (KeymapGroup)buildFileToGroup.get(buildFile);
                if (subGroup == null) {
                    subGroup = KeymapGroupFactory.getInstance().createGroup(buildFile.getPresentableName());
                    buildFileToGroup.put(buildFile, subGroup);
                    result.addGroup(subGroup);
                }
                subGroup.addActionId(id);
                continue;
            }
            LOG.info("No buildfile found for actionId=" + id);
        }
    }
}

