/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpParameterTemplate;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpParameterTableModelItem
extends ParameterTableModelItemBase<PhpParameterInfo>
implements PhpParameterTemplate {
    public String parameterCodeFragment;

    PhpParameterTableModelItem(PhpParameterInfo parameter, PsiCodeFragment typeCodeFragment, String parameterCodeFragment, PsiCodeFragment defaultValueCodeFragment) {
        super((Object)parameter, typeCodeFragment, defaultValueCodeFragment);
        this.parameterCodeFragment = parameterCodeFragment;
    }

    public boolean isEllipsisType() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((PhpParameterInfo)this.parameter).getName();
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getTypeText() {
        String string = ((PhpParameterInfo)this.parameter).getTypeText();
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public CharSequence getInitializer() {
        return ((PhpParameterInfo)this.parameter).getInitializer();
    }

    @Override
    public boolean isPassByRef() {
        return ((PhpParameterInfo)this.parameter).isPassByRef();
    }

    @Override
    public boolean isVariadic() {
        return ((PhpParameterInfo)this.parameter).isVariadic();
    }

    @Override
    public void updateParameter(Parameter newParameter) {
        String newName = newParameter.getName();
        String newType = PhpRefactoringUtil.getParameterTypeDeclarationString(newParameter);
        String newInitializer = PhpFunctionCodeGenerator.getInitializer(newParameter);
        String defaultValue = this.getDefaultValue();
        ((PhpParameterInfo)this.parameter).setName(newName);
        ((PhpParameterInfo)this.parameter).setDefaultValue(defaultValue);
        ((PhpParameterInfo)this.parameter).setInitializer(newInitializer);
        ((PhpParameterInfo)this.parameter).setTypeText(newType);
        ((PhpParameterInfo)this.parameter).setIsPassByRef(newParameter.isPassByRef());
        ((PhpParameterInfo)this.parameter).setVariadic(newParameter.isVariadic());
    }

    @Override
    @NotNull
    public String getParameterPreviewText() {
        String string = this.parameterCodeFragment;
        if (string == null) {
            PhpParameterTableModelItem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValueCodeFragment.getText().trim();
    }

    @Override
    public boolean shouldBeInitialized() {
        String oldInitializer = ((PhpParameterInfo)this.parameter).getInitializer();
        int index = ((PhpParameterInfo)this.parameter).getOldIndex();
        return StringUtil.isNotEmpty((String)oldInitializer) || index == -1;
    }

    public String getNewParameter() {
        StringBuilder builder = new StringBuilder();
        this.appendToString(builder);
        return builder.toString();
    }

    public void appendToString(StringBuilder builder) {
        builder.append(this.parameterCodeFragment);
    }

    public boolean defaultValueNeeded(Project project) {
        if (((PhpParameterInfo)this.parameter).getOldIndex() == -1) {
            return true;
        }
        if (StringUtil.isEmpty((String)((PhpParameterInfo)this.parameter).getInitializer())) {
            return false;
        }
        Parameter newParameter = this.constructParameter(project);
        return newParameter != null && newParameter.getDefaultValue() == null;
    }

    @Nullable
    public Parameter constructParameter(Project project) {
        StringBuilder builder = new StringBuilder();
        builder.append("function foo(");
        builder.append(this.parameterCodeFragment);
        builder.append("){}");
        return PhpPsiElementFactory.createFromText(project, Parameter.class, builder.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModelItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPreviewText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

