/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PhpMethodNode
extends MemberNodeBase<Function> {
    protected PhpMethodNode(Function method, Set<Function> called, Project project, Runnable cancelCallback) {
        super((PsiElement)method, called, project, cancelCallback);
    }

    protected MemberNodeBase<Function> createNode(Function caller, HashSet<Function> called) {
        return new PhpMethodNode(caller, called, this.myProject, this.myCancelCallback);
    }

    protected List<Function> computeCallers() {
        final ArrayList<Function> result = new ArrayList<Function>();
        final boolean isConstructor = this.myMethod instanceof Method && ((Method)this.myMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                Function parentFunction;
                PsiElement element = reference.getElement();
                Object parent = PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Function.INSTANCEOF);
                if (parent instanceof Function && !PhpMethodNode.this.isAlreadyAdded(parentFunction = (Function)parent) && (isConstructor || !PhpMethodNode.isReferenceFromChild(element, parentFunction))) {
                    result.add(parentFunction);
                }
                return false;
            }
        };
        PhpChangeSignatureUsageSearcher.processAllUsages((Function)this.myMethod, isConstructor, (CommonProcessors.FindProcessor<? super PsiReference>)finder);
        return result;
    }

    public static boolean isReferenceFromChild(@Nullable PsiElement element, @Nullable Function parent) {
        MethodReference reference;
        PhpExpression classReference;
        if (parent instanceof Method && element instanceof MethodReference && (classReference = (reference = (MethodReference)element).getClassReference()) != null && PhpLangUtil.equalsClassNames("parent", classReference.getName())) {
            return PhpLangUtil.equalsMethodNames(reference.getName(), parent.getName());
        }
        return false;
    }

    private boolean isAlreadyAdded(Function function) {
        return ((Function)this.myMethod).equals(function) || this.myCalled.contains(function);
    }

    protected void customizeRendererText(ColoredTreeCellRenderer renderer) {
        String functionView = PhpFunctionCodeGenerator.DECLARATION.generate((Function)this.myMethod);
        SimpleTextAttributes attributes = this.isEnabled() ? new SimpleTextAttributes(0, UIUtil.getTreeForeground()) : SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
        renderer.append(functionView, attributes);
        String path = PhpMethodNode.getPathToMethod((Function)this.myMethod);
        renderer.append("  (" + path + ")", new SimpleTextAttributes(2, Color.GRAY));
    }

    private static String getPathToMethod(Function function) {
        StringBuilder path = new StringBuilder();
        if (function instanceof Method) {
            PhpClass clazz = ((Method)function).getContainingClass();
            String fqn = clazz == null ? "" : clazz.getFQN();
            path.append(fqn == null ? "" : StringUtil.trimEnd((String)fqn, (String)"\\"));
            path.append(" ");
        }
        path.append("in ");
        path.append(function.getContainingFile().getName());
        return path.toString();
    }
}

