/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.intentions.PhpSimplifyBooleanIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.NotNull;

public class PhpFlipIfIntention
extends PsiElementBaseIntentionAction {
    public static final String TEXT = "Flip if-else";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!(PhpPsiUtil.isOfType(element, PhpTokenTypes.kwIF) || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwELSEIF) || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwELSE))) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof If || parent instanceof ElseIf || parent instanceof Else)) {
            return false;
        }
        ControlStatement controlStatement = PhpFlipIfIntention.getControlStatement(element);
        if (controlStatement.getCondition() == null) {
            return false;
        }
        if (controlStatement.getStatement() == null) {
            return false;
        }
        return PhpPsiUtil.getChildOfType((PsiElement)controlStatement, PhpTokenTypes.opCOLON) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ControlStatement controlStatement;
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(3);
        }
        if ((controlStatement = PhpFlipIfIntention.getControlStatement(element)) instanceof If) {
            PhpFlipIfIntention.flipIfElse(project, (If)controlStatement);
        } else if (controlStatement instanceof ElseIf) {
            If ifStatement = (If)controlStatement.getParent();
            ElseIf elseIfBranch = (ElseIf)controlStatement;
            int i = elseIfBranch.getTextRange().getStartOffset() - ifStatement.getTextRange().getStartOffset();
            String ifStatementText = ifStatement.getText();
            String targetIfStatementText = ifStatementText.substring(i + 4);
            If targetIfStatement = (If)PhpPsiElementFactory.createStatement(project, targetIfStatementText);
            PhpFlipIfIntention.flipIfElse(project, targetIfStatement);
            String newIfStatementText = ifStatementText.substring(0, i + 4) + targetIfStatement.getText();
            Statement newIfStatement = PhpPsiElementFactory.createStatement(project, newIfStatementText);
            ifStatement.replace((PsiElement)newIfStatement);
        }
    }

    private static ControlStatement getControlStatement(@NotNull PsiElement element) {
        Object controlStatement;
        if (element == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(4);
        }
        if ((controlStatement = element.getParent()) instanceof Else) {
            If ifStatement = (If)controlStatement.getParent();
            ElseIf[] elseIfBranches = ifStatement.getElseIfBranches();
            int length = elseIfBranches.length;
            controlStatement = length != 0 ? elseIfBranches[length - 1] : ifStatement;
        }
        return (ControlStatement)controlStatement;
    }

    private static void flipIfElse(@NotNull Project project, @NotNull If ifStatement) {
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(5);
        }
        if (ifStatement == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(6);
        }
        If ifStatementCopy = (If)ifStatement.copy();
        PhpFlipIfIntention.setupThenBranch(project, ifStatement.getStatement(), ifStatement.getElseIfBranches(), ifStatementCopy.getElseBranch());
        PhpFlipIfIntention.setupElseBranch(project, ifStatement, ifStatementCopy.getStatement());
        PhpFlipIfIntention.updateCondition(project, ifStatement);
    }

    private static void setupThenBranch(@NotNull Project project, Statement thenBranch, ElseIf[] elseIfBranches, Else elseBranchCopy) {
        boolean needBraces;
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(7);
        }
        StringBuilder newThenBranchText = new StringBuilder(1024);
        boolean elseIf = elseIfBranches.length != 0;
        boolean bl = needBraces = elseIf || elseBranchCopy == null || !(elseBranchCopy.getStatement() instanceof GroupStatement);
        if (needBraces) {
            newThenBranchText.append('{');
        }
        for (int i = 0; i < elseIfBranches.length; ++i) {
            ElseIf elseIfBranch = elseIfBranches[i];
            String text = elseIfBranch.getText();
            if (i == 0) {
                text = text.substring(4);
            }
            newThenBranchText.append(text);
            elseIfBranch.delete();
        }
        if (elseBranchCopy != null) {
            if (elseIf) {
                newThenBranchText.append(elseBranchCopy.getText());
            } else {
                PhpPsiElement elseBranchCopyStatement = elseBranchCopy.getStatement();
                if (elseBranchCopyStatement != null) {
                    newThenBranchText.append(elseBranchCopyStatement.getText());
                }
            }
        }
        if (needBraces) {
            newThenBranchText.append('}');
        }
        Statement newThenBranch = PhpPsiElementFactory.createStatement(project, newThenBranchText.toString());
        thenBranch.replace((PsiElement)newThenBranch);
    }

    private static void setupElseBranch(@NotNull Project project, If ifStatement, Statement thenBranchCopy) {
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(8);
        }
        Else elseBranch = ifStatement.getElseBranch();
        if (PhpFlipIfIntention.isEmpty(thenBranchCopy)) {
            if (elseBranch != null) {
                elseBranch.delete();
            }
        } else if (elseBranch != null) {
            String newElseStatementText = PhpFlipIfIntention.getNewElseStatementText(thenBranchCopy);
            Statement newElseStatement = PhpPsiElementFactory.createStatement(project, newElseStatementText);
            PhpPsiElement elseBranchStatement = elseBranch.getStatement();
            if (elseBranchStatement != null) {
                elseBranchStatement.replace((PsiElement)newElseStatement);
            } else {
                elseBranch.add((PsiElement)newElseStatement);
            }
        } else {
            String newIfStatementText = "if (true) {} else " + PhpFlipIfIntention.getNewElseStatementText(thenBranchCopy);
            If newIfStatement = (If)PhpPsiElementFactory.createStatement(project, newIfStatementText);
            Else newElseBranch = newIfStatement.getElseBranch();
            assert (newElseBranch != null);
            ifStatement.add((PsiElement)newElseBranch);
        }
    }

    private static boolean isEmpty(Statement statement) {
        if (statement instanceof GroupStatement) {
            PsiElement[] statements;
            for (PsiElement s : statements = statement.getChildren()) {
                if (s instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getNewElseStatementText(@NotNull Statement thenBranchCopy) {
        if (thenBranchCopy == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(9);
        }
        return thenBranchCopy instanceof GroupStatement ? thenBranchCopy.getText() : '{' + thenBranchCopy.getText() + '}';
    }

    private static void updateCondition(@NotNull Project project, If ifStatement) {
        if (project == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(10);
        }
        PhpPsiElement condition = ifStatement.getCondition();
        assert (condition != null);
        String newConditionText = PhpSimplifyBooleanIntention.invertExpression((PhpExpression)condition, 0);
        PhpExpression newCondition = PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, newConditionText);
        PhpCodeEditUtil.replace((PsiElement)condition, newCondition);
    }

    @NotNull
    public String getText() {
        if (TEXT == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(11);
        }
        return TEXT;
    }

    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            PhpFlipIfIntention.$$$reportNull$$$0(12);
        }
        return TEXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranchCopy";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpFlipIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpFlipIfIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getControlStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flipIfElse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupThenBranch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupElseBranch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNewElseStatementText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateCondition";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

