/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.strictStandards;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSuperClassIncompatibleWithInterfaceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpSuperClassIncompatibleWithInterfaceInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isInterface() || clazz.isTrait()) {
                    return;
                }
                if (clazz.getSuperFQN() == null && !clazz.hasTraitUses() || clazz.getInterfaceNames().length == 0) {
                    return;
                }
                Set ownMethodsNames = StreamEx.of((Object[])clazz.getOwnMethods()).map(PhpNamedElement::getName).toSet();
                Map<String, Method> interfacesImplicitMethods = this.getInterfacesImplicitMethods(clazz, ownMethodsNames);
                if (interfacesImplicitMethods.isEmpty()) {
                    return;
                }
                Ref classMethod = new Ref(null);
                Ref interfaceMethod = new Ref(null);
                Ref reason = new Ref(null);
                Ref target = new Ref((Object)clazz.getExtendsList());
                PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)false, (boolean)false, superClass -> {
                    if (superClass.isInterface()) {
                        return true;
                    }
                    for (Method method : superClass.getOwnMethods()) {
                        String methodName = method.getName();
                        Method implementedMethod = (Method)interfacesImplicitMethods.get(methodName);
                        if (implementedMethod == null || ownMethodsNames.contains(methodName)) continue;
                        boolean interfaceMethodStatic = implementedMethod.isStatic();
                        if (method.isStatic() != interfaceMethodStatic) {
                            reason.set((Object)("cannot make interface method " + (interfaceMethodStatic ? "non static" : "static")));
                        } else if (implementedMethod.getAccess().isWeakerThan(method.getAccess())) {
                            reason.set((Object)"access must be public");
                        } else if (this.haveCompatibleReturnTypes(implementedMethod, method) && ((Boolean)PhpHierarchyChecksInspection.checkDeclarationsCompatibility((Method)implementedMethod, (Method)method).first).booleanValue()) {
                            return true;
                        }
                        classMethod.set((Object)method);
                        interfaceMethod.set((Object)implementedMethod);
                        if (superClass.isTrait()) {
                            target.set((Object)this.findContainingInterface(clazz.getImplementsList(), implementedMethod));
                        }
                        return false;
                    }
                    return true;
                });
                if (classMethod.get() != null && interfaceMethod.get() != null) {
                    PhpClass superClass2 = ((Method)classMethod.get()).getContainingClass();
                    PhpClass anInterface = ((Method)interfaceMethod.get()).getContainingClass();
                    if (superClass2 != null && anInterface != null) {
                        holder.registerProblem((PsiElement)target.get(), this.getMessage(superClass2, (Method)classMethod.get(), anInterface, (Method)interfaceMethod.get(), (String)reason.get()), new LocalQuickFix[0]);
                    }
                }
            }

            private boolean haveCompatibleReturnTypes(@NotNull Method interfaceMethod, @NotNull Method method) {
                PhpType interfaceMethodType;
                if (interfaceMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (interfaceMethodType = interfaceMethod.getDeclaredType()).isEmpty() || interfaceMethodType.equals((Object)method.getDeclaredType());
            }

            @NotNull
            private PsiElement findContainingInterface(@NotNull ImplementsList implementsList, @NotNull Method method) {
                if (implementsList == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (method == null) {
                    1.$$$reportNull$$$0(3);
                }
                List implementedInterfaces = implementsList.getReferenceElements();
                PhpClass containingInterface = method.getContainingClass();
                if (containingInterface != null) {
                    String containingInterfaceFqn = containingInterface.getFQN();
                    for (ClassReference implementedInterface : implementsList.getReferenceElements()) {
                        if (!PhpLangUtil.equalsClassNames(containingInterfaceFqn, implementedInterface.getFQN())) continue;
                        ClassReference classReference = implementedInterface;
                        if (classReference == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return classReference;
                    }
                }
                ImplementsList implementsList2 = implementsList;
                if (implementsList2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                return implementsList2;
            }

            @NotNull
            private Map<String, Method> getInterfacesImplicitMethods(@NotNull PhpClass clazz, @NotNull Set<String> ownMethodsNames) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (ownMethodsNames == null) {
                    1.$$$reportNull$$$0(7);
                }
                HashMap interfacesImplicitMethods = ContainerUtil.newHashMap();
                PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)clazz, (boolean)false, (boolean)false, anInterface -> {
                    if (ownMethodsNames == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    for (Method method : anInterface.getOwnMethods()) {
                        String name = method.getName();
                        if (ownMethodsNames.contains(name)) continue;
                        interfacesImplicitMethods.putIfAbsent(name, method);
                    }
                    return true;
                });
                HashMap hashMap = interfacesImplicitMethods;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(8);
                }
                return hashMap;
            }

            @NotNull
            private String getMessage(@NotNull PhpClass superClass, @NotNull Method superClassMethod, @NotNull PhpClass anInterface, @NotNull Method interfaceMethod, @Nullable String reason) {
                if (superClass == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (superClassMethod == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (anInterface == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (interfaceMethod == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (!isOnTheFly) {
                    if ("Declaration of super class incompatible with interface" == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    return "Declaration of super class incompatible with interface";
                }
                String baseMessage = PhpBundle.message("inspection.super.incompatible.with.interface.declaration.must.be.compatible", PhpHierarchyChecksInspection.buildSuperName(superClassMethod, superClass), PhpHierarchyChecksInspection.buildSuperName(interfaceMethod, anInterface));
                String string = reason != null ? baseMessage + ", " + reason : baseMessage;
                if (string == null) {
                    1.$$$reportNull$$$0(14);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 14: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 14: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interfaceMethod";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "implementsList";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 7: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ownMethodsNames";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "superClass";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "superClassMethod";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anInterface";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection$1";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findContainingInterface";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInterfacesImplicitMethods";
                        break;
                    }
                    case 13: 
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "haveCompatibleReturnTypes";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "findContainingInterface";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 14: {
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "getInterfacesImplicitMethods";
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getMessage";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$getInterfacesImplicitMethods$1";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 8: 
                    case 13: 
                    case 14: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (phpElementVisitor == null) {
            PhpSuperClassIncompatibleWithInterfaceInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/strictStandards/PhpSuperClassIncompatibleWithInterfaceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

