/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.assignment.PhpReplaceableAssignmentCondition;
import com.jetbrains.php.lang.inspections.quickfix.assignment.ReplaceAssignmentWithOperatorAssignmentQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PhpAssignmentReplaceableWithOperatorAssignmentInspection
extends PhpInspection {
    private static final Condition<AssignmentExpression> REPLACEABLE_ASSIGNMENT_CONDITION;
    private static final Map<String, ReplaceAssignmentWithOperatorAssignmentQuickFix[]> fixesCache;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAssignmentReplaceableWithOperatorAssignmentInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpAssignmentExpression(AssignmentExpression assignment) {
                if (REPLACEABLE_ASSIGNMENT_CONDITION.value((Object)assignment)) {
                    BinaryExpression expression = (BinaryExpression)assignment.getValue();
                    assert (expression != null);
                    String operator = ReplaceAssignmentWithOperatorAssignmentQuickFix.getOperatorText(expression);
                    String name = PhpBundle.message("quickfix.replace.assignment.with.operator.assignment.name", operator);
                    LocalQuickFix[] fixes = (ReplaceAssignmentWithOperatorAssignmentQuickFix[])fixesCache.get(name);
                    if (fixes == null) {
                        fixes = new ReplaceAssignmentWithOperatorAssignmentQuickFix[]{new ReplaceAssignmentWithOperatorAssignmentQuickFix(name)};
                        fixesCache.put(name, fixes);
                    }
                    String replacementExpression = fixes[0].getReplacementExpressionString(assignment);
                    String message = PhpBundle.message("inspection.assignment.replaceable.with", replacementExpression);
                    holder.registerProblem((PsiElement)assignment, message, ProblemHighlightType.INFORMATION, fixes);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpAssignmentReplaceableWithOperatorAssignmentInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    static {
        fixesCache = new HashMap<String, ReplaceAssignmentWithOperatorAssignmentQuickFix[]>();
        TokenSet replaceableOperatorTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsMATH_OPS, PhpTokenTypes.tsBIT_BINARY_OPS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCONCAT})});
        TokenSet commutativeOperatorTypes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMUL, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR, PhpTokenTypes.opBIT_XOR});
        REPLACEABLE_ASSIGNMENT_CONDITION = new PhpReplaceableAssignmentCondition(replaceableOperatorTypes, commutativeOperatorTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/assignment/PhpAssignmentReplaceableWithOperatorAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/assignment/PhpAssignmentReplaceableWithOperatorAssignmentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

