/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.UnknownDBException;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;

public class BaseExceptionRecognizer
implements DBExceptionRecognizer {
    @Override
    @NotNull
    public final DBException recognizeException(@NotNull SQLException sqle, @Nullable String statementText) {
        SQLException e = sqle;
        while (e.getCause() != null && e.getCause() instanceof SQLException) {
            e = (SQLException)e.getCause();
        }
        DBException exception = this.recognizeSpecificException(e, statementText);
        if (exception == null) {
            exception = new UnknownDBException(e, statementText);
        }
        return exception;
    }

    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        return null;
    }

    @Nullable
    protected <E extends DBException> E instantiateDBException(@NotNull Class<? extends E> exceptionClass, @NotNull SQLException sqle, @Nullable String statementText) {
        try {
            Constructor<E> constructor = exceptionClass.getConstructor(SQLException.class, String.class);
            return (E)((DBException)constructor.newInstance(sqle, statementText));
        }
        catch (Exception e) {
            return null;
        }
    }
}

